//
//  YHSelectCountryViewModel.swift
//  galaxy
//
//  Created by EDY on 2024/1/31.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHSelectCountryViewModel: NSObject {
    override init() {
        super.init()
    }
    
    func requestCountry(_ key: String, callBackBlock: @escaping (_ success: [YHCountryMessage?]?, _ error: YHErrorModel?) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.OrderInformation.countryInformation
        let param: [String: Any] = ["keyword": key]
        _ = YHNetRequest.getRequest(url: strUrl, params: param) { [weak self] json, _ in
            guard self != nil else { return }
            guard let dic = json.data?.peel as?  [Any], let resultArray = [YHCountryMessage].deserialize(from: dic) else {
                callBackBlock([], nil)
                return
            }
            callBackBlock(resultArray, nil)
        } failBlock: { err in
            callBackBlock([], err)
        }

    }
}
