//
//  YHPlanShareImageCellCollectionViewCell.swift
//  galaxy
//
//  Created by Dufet on 2025/3/31.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHPlanShareImageCell: UICollectionViewCell {
    
    static let cellReuseIdentifier = "YHPlanShareImageCell"

    var model: YHPlanPolicyImageInfo = YHPlanPolicyImageInfo() {
        didSet {
            
            if let url = URL(string: model.model.image_poster) {
                imgView.kf.setImage(with: url, placeholder: UIImage(named: "global_default_image"))
            } else {
                imgView.image = UIImage(named: "global_default_image")
            }
            
            imgView.snp.remakeConstraints { make in
                make.top.bottom.equalToSuperview()
                make.centerX.equalToSuperview()
                make.width.equalTo(imgView.snp.height).multipliedBy(model.width/model.height)
            }
            self.setNeedsLayout()
            self.layoutIfNeeded()
        }
    }
    lazy var imgContentView: UIView = {
        let v = UIView()
        v.backgroundColor = .clear
        v.clipsToBounds = true
        return v
    }()
    
    lazy var imgView: UIImageView = {
        let v = UIImageView()
        v.contentMode = .scaleAspectFit
        return v
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }

    private func setupUI() {
        
        contentView.addSubview(imgContentView)
        imgContentView.addSubview(imgView)
        imgContentView.snp.makeConstraints { make in
            make.left.equalTo(20)
            make.right.equalTo(-20)
            make.top.bottom.equalToSuperview()
        }
        
        imgView.snp.makeConstraints { make in
            make.top.bottom.equalToSuperview()
            make.centerX.equalToSuperview()
            make.width.equalTo(imgView.snp.height).multipliedBy(1.0)
        }
    }
}
