//
//  UIColor-Extension.swift
//  DouYuUI
//
//  Created by davidhuang on 2022/8/9.
//  Copyright © 2022 davidhuang. All rights reserved.
//

import UIKit
// import SwifterSwift

extension UIColor {
    
    // 主品牌色
    static let brandMainColor: UIColor = UIColor(hexString: "#0046B4")!
    
    // 品牌渐变色
    static let arrBrandGradaterColors: [UIColor] = [UIColor(hexString: "#0046B4")!, UIColor(hexString: "#0046B4")!]
    
    // 品牌主色 30
    static let brandMainColor30: UIColor = UIColor(hexString: "#0046B4", transparency: 0.3)!
    
    // 品牌主色 50
    static let brandMainColor50: UIColor = UIColor(hexString: "#0046B4", transparency: 0.5)!

    // 品牌主色 16
    static let brandMainColor16: UIColor = UIColor(hexString: "#0046B4", transparency: 0.16)!
    
    // 品牌主色 8
    static let brandMainColor8: UIColor = UIColor(hexString: "#0046B4", transparency: 0.08)!
    
    // 品牌主色 6
    static let brandMainColor6: UIColor = UIColor(hexString: "#0046B4", transparency: 0.06)!
    
    public static func brandMainColor(alpha: CGFloat) -> UIColor {
        return UIColor(hexString: "#0046B4", transparency: alpha)!
    }
    
    // 标题/主内容
    static let mainTextColor: UIColor = UIColor(hexString: "#121A26")!
    static let mainTextColor5: UIColor = UIColor(hexString: "#121A26", transparency: 0.05)!
    static let mainTextColor18: UIColor = UIColor(hexString: "#121A26", transparency: 0.18)!
    static let mainTextColor30: UIColor = UIColor(hexString: "#121A26", transparency: 0.3)!
    static let mainTextColor50: UIColor = UIColor(hexString: "#121A26", transparency: 0.5)!
    static let mainTextColor70: UIColor = UIColor(hexString: "#121A26", transparency: 0.7)!
    
    public static func mainTextColor(alpha: CGFloat) -> UIColor {
        return UIColor(hexString: "#121A26", transparency: alpha)!
    }
    
    // 次内容一
    static let subTextColor: UIColor = UIColor(hexString: "#4E4E4E")!
    
    // 次内容二
    static let subTextColor2: UIColor = UIColor(hexString: "#7A7A7A")!
    
    // 标注内容一
    static let labelTextColor: UIColor = UIColor(hexString: "#D3D3D3")!
    
    // 标注内容二
    static let labelTextColor2: UIColor = UIColor(hexString: "#888F98")!
    
    // 成功 color
    static let successColor: UIColor = UIColor(hexString: "#49D2B1")!
    
    // 失败 color
    static let failColor: UIColor = UIColor(hexString: "#F81D22")!
    
    // 警告 color
    static let warnColor: UIColor = UIColor(hexString: "#FF9900")!
    
    // 警告 背景色 color
    static let warnColor8: UIColor = UIColor(hexString: "#FF9900", transparency: 0.08)!

    // 提示 color
    static let tipsColor: UIColor = UIColor(hexString: "#2F7EF6")!
    static let tipsColor8: UIColor = UIColor(hexString: "#2F7EF6", transparency: 0.08)!
    
    // 页面背景
    static let pageBkgColor: UIColor = UIColor(hexString: "#F8F8F8")!
    static let pageBkgColor40: UIColor = UIColor(hexString: "#94A3B8", transparency: 0.4)!
    
    // 内容背景色
    static let contentBkgColor: UIColor = UIColor(hexString: "#F8F9FB")!
    
    // 占位符颜色
    static let placeHolderColor: UIColor = UIColor(hexString: "#C0C0C0")!
    
    // 分割线颜色
    static let separatorColor: UIColor = UIColor(hexString: "#F0F0F0")!
    
    // 导航栏标题颜色
    static let navTitleColor: UIColor = UIColor(hexString: "#0F1214")!
    
    // alertView 底部蒙层颜色
    static let alertMaskColor: UIColor = UIColor.init(hex: 0x0F1214, alpha: 0.5)
    
    // 94a3b8
    static let yhGreyColor: UIColor = UIColor(hexString: "#94A3B8")!
    static let yhGreyColor50: UIColor = UIColor(hexString: "#94A3B8", transparency: 0.5)!
    
    // 常见按钮色
    static let yhOrangeColor: UIColor = UIColor(hexString: "#FF8000")!
    static let yhGreenColor: UIColor = UIColor(hexString: "#3CC694")!
    
    public convenience init(r: CGFloat, g: CGFloat, b: CGFloat, alpha: CGFloat = 1.0) {
        self.init(red: r / 255.0, green: g / 255.0, blue: b / 255.0, alpha: alpha)
    }
    
    // 根据色值生成颜色(无透明度)(格式为0xffffff)
    public convenience init(hex: NSInteger, alpha: CGFloat = 1.0) {
        self.init(red: ((CGFloat)((hex & 0xFF0000) >> 16)) / 255.0, green: ((CGFloat)((hex & 0xFF00) >> 8)) / 255.0, blue: ((CGFloat)(hex & 0xFF)) / 255.0, alpha: alpha)
    }
    
    // 生成 对应色值的图片
    public func toImage(width: Double = 1.0, height: Double = 1.0) -> UIImage {
        let rect = CGRect(x: 0.0, y: 0.0, width: width, height: height)
        UIGraphicsBeginImageContext(rect.size)
        let ctx = UIGraphicsGetCurrentContext()
        ctx!.setFillColor(self.cgColor)
        ctx!.fill(rect)
        let image = UIGraphicsGetImageFromCurrentImageContext()
        UIGraphicsEndImageContext()
        return image!
    }
    
    static func randomColor() -> UIColor {
        let red = CGFloat(arc4random_uniform(256)) / 255.0
        let green = CGFloat(arc4random_uniform(256)) / 255.0
        let blue = CGFloat(arc4random_uniform(256)) / 255.0
        return UIColor(red: red, green: green, blue: blue, alpha: 1.0)
    }
}
