//
//  YHAIHistoryMessage.swift
//  galaxy
//
//  Created by Dufet on 2024/12/3.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SmartCodable

class YHAIHistoryMessage: SmartCodable {
    
    var botId: String = ""
    var chatId: String = ""
    var contentText: String = ""
    var contentType: Int = 0
    var messageId: String = ""
    var role: String = ""
    var type: String = ""
    
    var cardsInfo: YHAIListInfoModel?
    var imageInfo: YHAIImageInfo?

    required init() {
        
    }
    
    func convertToChatMessage() -> YHAIChatMessage {
        
        let msg = YHAIChatMessage()
        msg.messageId = self.messageId
        msg.isSelf = self.role == "user"
        msg.isDone = true
        let body = YHAIMessageBody()
        body.contentType = self.contentType
        body.contentText = self.contentText
        body.botId = self.botId
        body.chatId = self.chatId
        body.type = self.type
        body.cardsInfo = self.cardsInfo
        body.imageInfo = self.imageInfo
        msg.body = body
        msg.setDone()
        msg.updateBodyToData()
        return msg
    }
}
