//
//  YHServiceCenterProgressModel.swift
//  galaxy
//
//  Created by davidhuangA on 2024/4/16.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SmartCodable

class YHServiceCenterProgressModel: SmartCodable {
    var name: String = ""
    var percentage: Int = 0
    var status: Int = 0 // 0未知 1待开始 2进行中 3 已完成 4 后台进行中
    var num: Int = 0
    var type: Int = 0 // 1 证件 2 信息完善 3 我的评分 4 我的方案 5 我的签字 6我的文书
    var pro_version: Int = 0
    var reject_status: Int = 0
    required init() {
    }
}

class YHServiceSearchModel: SmartCodable {
    var id: Int = 0
    var dictionary_code: String = ""
    var enable_flag: Int = 0
    required init() {
    }
}
class YHServiceProgressModel: SmartCodable {
    var title: String = ""
    var type: Int = 0
    var list: [YHServiceCenterProgressModel] = []
    required init() {
    }
}

struct YHServiceStepProgressModel: SmartCodable {
    var title: String = ""
    var type: Int = 0
    var list: [YHServiceStepProgressThreeModel] = []
}

struct YHServiceStepProgressThreeModel: SmartCodable {
    var personStr: String = ""
    var id: Int = 0
    var list: [YHServiceCenterProgressModel] = []
}

struct YHServiceCenterMainModel: SmartCodable {
    var applySection: YHServiceProgressModel = YHServiceProgressModel() // 申请阶段
    var certificateSection: YHServiceProgressModel = YHServiceProgressModel() // 办证阶段
    var renewalSection: YHServiceStepProgressModel = YHServiceStepProgressModel() // 优才续签阶段
    var permanentSection: YHServiceStepProgressModel = YHServiceStepProgressModel() // 永居
    var renewalNewSection: YHServiceStepProgressModel = YHServiceStepProgressModel() // 高专留续签段
    var stage: Int = 0 // 1 申请阶段 2办证阶段 3优才续签阶段 4永居 5高专留续签段
    var master_id: Int = 0 // 批次
    var status: Int = 0
    var category_type: Int = 0 // 1.优才 2.高才 3永居 4专才 5留学
}
