//
//  YHServiceOrderTipsView.swift
//  galaxy
//
//  Created by EDY on 2024/11/12.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHServiceOrderTipsView: UIView {
    var titleLabel: UIImageView!
    var knowButton: UIButton!
    var measageLabel: UILabel!
    var isOn: Bool = false
    var dismissEvent: (() -> Void)?

    @discardableResult
    static func show() -> YHServiceOrderTipsView {
        let view = YHServiceOrderTipsView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: KScreenHeight))
        view.isOn = true
        let window = UIApplication.shared.yhKeyWindow()
        window?.addSubview(view)
        return view
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = UIColor(hex: 0x000000).withAlphaComponent(0.7)
        let tap = UITapGestureRecognizer(target: self, action: #selector(handleTap))
        tap.delegate = self
        addGestureRecognizer(tap)
        setView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setView() {
        backgroundColor = UIColor(hex: 0x0000, alpha: 0.5)
        
        titleLabel = {
            let label = UIImageView()
            label.image = UIImage(named: "service_center_tips_image")
            return label
        }()
        addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.top.equalTo(85)
            make.height.equalTo(112)
            make.width.equalTo(254)
            make.right.equalTo(-20)
        }
        
        knowButton = {
            let button = UIButton(type: .custom)
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 15)
            button.contentHorizontalAlignment = .center
            button.setTitle("我知道了", for: .normal)
            button.setTitleColor( UIColor.white, for: .normal)
            button.layer.cornerRadius = kCornerRadius3
            button.layer.borderWidth = 1
            button.layer.borderColor = UIColor.white.cgColor
            button.clipsToBounds = true
            button.addTarget(self, action: #selector(goNext), for: .touchUpInside)
            return button
        }()
        addSubview(knowButton)
        knowButton.snp.makeConstraints { make in
            make.top.equalTo(298)
            make.centerX.equalToSuperview()
            make.height.equalTo(46)
            make.width.equalTo(96)
        }
        
        measageLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 14)
            label.textColor = UIColor.white
            label.text = "点击右上方可以\n切换服务进度、查看申请操作指引"
            label.numberOfLines = 0
            label.textAlignment = .center
            return label
        }()
        addSubview(measageLabel)
        measageLabel.snp.makeConstraints { make in
            make.right.equalTo(-21)
            make.left.equalTo(21)
            make.top.equalTo(242)
            make.height.equalTo(44)

        }
            
    }
    
    @objc private func handleTap(_ sender: AnyObject?) {
        dismiss()
    }
    
    @objc func dismiss() {
        isOn = false
        removeFromSuperview()
        UserDefaults.standard.set(true, forKey: "service_tip_show")
        dismissEvent?()
    }
    
    @objc func goNext() {
        dismiss()
    }
}

extension YHServiceOrderTipsView: UIGestureRecognizerDelegate {
    func gestureRecognizer(_ gestureRecognizer: UIGestureRecognizer, shouldReceive touch: UITouch) -> Bool {
        if touch.view == self {
            return true
        }
        return false
    }
}
