//
//  YHResignCertificateDetailViewModel.swift
//  galaxy
//
//  Created by EDY on 2024/9/12.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHResignCertificateDetailViewModel: YHBaseViewModel {
    var dataModel: YHResignCertificateModel = YHResignCertificateModel()

    func submitResignCertificateUpdate(_ params: [String: Any], callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.ResignCertificate.update
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            printLog("model 是 ==> \(json)")
            
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callBackBlock(false, err)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func getCertificateDetail(_ cerId: Int, callback: ((_ model: YHResignCertificateModel?, _ error: YHErrorModel?) -> Void)?) {
        
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.ResignCertificate.certificateDetail
        _ = YHNetRequest.getRequest(url: strUrl, params: ["id": cerId]) { json, _ in
            // 1. json字符串 转 对象
            printLog("model 是 ==> \(json)")
            
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let resultModel = YHResignCertificateModel.deserialize(from: dic) else {
                    let err = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    callback?(nil, err)
                    return
                }
                callback?(resultModel, nil)
                
            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callback?(nil, err)
            }
            
        } failBlock: { err in
            callback?(nil, err)
        }
    }
    
    func getBaseDatadSource(_ isShowPrompt: Bool) -> [YHItemModel] {
        
        let item5 = YHItemModel(id: .id36, isNeed: true, title: "证件号码", isUserKeyBoard: true, prompts: "请输入", message: dataModel.cert_info.number, isShowPrompts: isShowPrompt, alertMessage: "请输入证件号码")
        let item6 = YHItemModel(id: .id37, isNeed: true, title: "签发地", isUserKeyBoard: true, prompts: "请输入", message: dataModel.cert_info.address, isShowPrompts: isShowPrompt, alertMessage: "请输入签发地")
        
        let item1 = YHItemModel(id: .id38, isNeed: true, title: "签发日期", isUserKeyBoard: false, prompts: "请选择", message: getResultString(dataModel.cert_info.issue_start), type: .time, isShowPrompts: isShowPrompt, alertMessage: "请选择签发日期")
        let item2 = YHItemModel(id: .id39, isNeed: true, title: "届满日期", isUserKeyBoard: false, prompts: "请选择", message: getResultString(dataModel.cert_info.issue_end), type: .time, isShowPrompts: isShowPrompt, alertMessage: "请选择届满日期")
        let item3 = YHItemModel(id: .id3, isNeed: true, title: "开始时间", isUserKeyBoard: false, prompts: "请选择", message: getResultString(dataModel.cert_info.validate_start), type: .time, isShowPrompts: isShowPrompt, alertMessage: "请选择开始时间")
        let item4 = YHItemModel(id: .id4, isNeed: true, title: "到期时间", isUserKeyBoard: false, prompts: "请选择", message: getResultString(dataModel.cert_info.validate_end), type: .time, isShowPrompts: isShowPrompt, alertMessage: "请选择到期时间")
        return [item5, item6, item1, item2, item3, item4]
    }
    
    func getPassPortdDataSource(_ isShowPrompt: Bool) -> [YHItemModel] {
        
        let item3 = YHItemModel(id: .id36, isNeed: true, title: "证件号码", isUserKeyBoard: true, prompts: "请输入", message: dataModel.cert_info.number, isShowPrompts: isShowPrompt, alertMessage: "请输入证件号码")
        let item4 = YHItemModel(id: .id37, isNeed: true, title: "签发地", isUserKeyBoard: true, prompts: "请输入", message: dataModel.cert_info.address, isShowPrompts: isShowPrompt, alertMessage: "请输入签发地")
        
        let item1 = YHItemModel(id: .id38, isNeed: true, title: "签发日期", isUserKeyBoard: false, prompts: "请选择", message: getResultString(dataModel.cert_info.issue_start), type: .time, isShowPrompts: isShowPrompt, alertMessage: "请选择签发日期")
        let item2 = YHItemModel(id: .id39, isNeed: true, title: "届满日期", isUserKeyBoard: false, prompts: "请选择", message: getResultString(dataModel.cert_info.issue_end), type: .time, isShowPrompts: isShowPrompt, alertMessage: "请选择届满日期")
        
        return [item3, item4, item1, item2]
    }
    
    func updatesModel(_ item: YHItemModel) {
        guard let type = item.id else { return }
        switch type {
        case .id38:
            dataModel.cert_info.issue_start = item.message ?? ""
        case .id39:
            dataModel.cert_info.issue_end = item.message ?? ""
        case .id3:
            dataModel.cert_info.validate_start = item.message ?? ""
        case .id4:
            dataModel.cert_info.validate_end = item.message ?? ""
        case .id36:
            dataModel.cert_info.number = item.message ?? ""
        case .id37:
            dataModel.cert_info.address = item.message ?? ""
        default:
            break
        }
    }
    
    func getResultString(_ data: String) -> String {
        let dateString = data // 原始日期时间字符串
        let dateFormatter = DateFormatter()
        dateFormatter.dateFormat = "yyyy-MM-dd HH:mm:ss" // 设置原始日期时间格式
        if let date = dateFormatter.date(from: dateString) {
            dateFormatter.dateFormat = "yyyy-MM-dd" // 设置目标日期格式
            let convertedDateString = dateFormatter.string(from: date) // 转换日期到目标格式
            return convertedDateString
        }
        return data
    }
}
