//
//  YHResignHaveAppointedApplicantsInfoCell.swift
//  galaxy
//
//  Created by edy on 2024/10/10.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHResignHaveAppointedApplicantsInfoCell: UITableViewCell {

    static let cellReuseIdentifier = "YHResignHaveAppointedApplicantsInfoCell"

    lazy var whiteContentView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.layer.cornerRadius = kCornerRadius6
        return view
    }()
    
    lazy var lineView: UIView = {
        let view = UIView()
        view.backgroundColor = .separatorColor
        return view
    }()
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.numberOfLines = 0
        label.font = UIFont.PFSC_M(ofSize: 17)
        label.textColor = .mainTextColor
        label.text = "第?批赴港递交信息"
        return label
    }()
    
    lazy var applicantTitleLabel: UILabel = {
        let label = UILabel()
        label.numberOfLines = 0
        label.font = UIFont.PFSC_R(ofSize: 14)
        label.textColor = .mainTextColor
        label.text = "赴港递交申请人"
        return label
    }()
    
    lazy var applicantContentView: UIView = {
        let view = UIView()
        view.backgroundColor = .init(hex: 0xF8F9FB)
        return view
    }()
    
    lazy var applicantNamesLabel: UILabel = {
        let label = UILabel()
        label.numberOfLines = 0
        label.font = UIFont.PFSC_M(ofSize: 14)
        label.textColor = .mainTextColor
        label.text = "成员："
        return label
    }()
    
    lazy var submitTimeView: YHResignAppointShowTimeItemView = {
        let view = YHResignAppointShowTimeItemView()
        view.title = "预约在港递交时间"
        view.detail = "2024-03-14 15:00"
        return view
    }()
    
    lazy var leaveHKTimeView: YHResignAppointShowTimeItemView = {
        let view = YHResignAppointShowTimeItemView()
        view.title = "预计离港时间"
        view.detail = "2024-03-14 21:00"
        return view
    }()
    
    lazy var leaveHKSwithView: YHResignLeaveHKSwitchItemView = {
        let view = YHResignLeaveHKSwitchItemView()
        view.title = "暂不离港"
        view.switchBtn.isUserInteractionEnabled = false
        view.switchBtn.isOn = true
        view.switchBtn.alpha = 0.3
        view.selectBlock = nil
        return view
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func updateModel(_ model: YHResignAppointTimeSettingModel) {
        titleLabel.text = "第\(String.convertNumberToChineseText(model.itemIndex+1))批赴港递交信息"
        var names = "成员："
        for (index, user) in model.users.enumerated() {
            names += user.apply_name
            if index != model.users.count-1 {
                names += "、"
            }
        }
        applicantNamesLabel.text = names
        submitTimeView.detail = model.getSubmitHKTime()
        
        leaveHKTimeView.snp.removeConstraints()
        leaveHKTimeView.isHidden = model.notleaveHK
        leaveHKTimeView.detail = model.getLeaveHKTime()

        leaveHKSwithView.snp.removeConstraints()
        leaveHKSwithView.isHidden = !model.notleaveHK
        
        if model.notleaveHK { // 暂不离港  显示预约在港递交时间和暂不离港两行
            
            leaveHKSwithView.snp.remakeConstraints { make in
                make.left.equalTo(18)
                make.right.equalTo(-18)
                make.top.equalTo(submitTimeView.snp.bottom)
                make.bottom.equalTo(0)
            }
            
        } else { // 离港   显示预约在港递交时间和预计离港时间两行
            
            leaveHKTimeView.snp.remakeConstraints { make in
                make.left.equalTo(18)
                make.right.equalTo(-18)
                make.top.equalTo(submitTimeView.snp.bottom).offset(0)
                make.bottom.equalTo(0)
            }
        }
        
        self.setNeedsLayout()
        self.layoutIfNeeded()

    }
    
    func setupUI() {
        
        self.selectionStyle = .none
        self.backgroundColor = .clear
        self.contentView.backgroundColor = .clear
        contentView.addSubview(whiteContentView)
        whiteContentView.addSubview(titleLabel)
        whiteContentView.addSubview(lineView)
        whiteContentView.addSubview(applicantTitleLabel)
        whiteContentView.addSubview(applicantContentView)
        applicantContentView.addSubview(applicantNamesLabel)
        whiteContentView.addSubview(submitTimeView)
        whiteContentView.addSubview(leaveHKTimeView)
        whiteContentView.addSubview(leaveHKSwithView)
        
        whiteContentView.snp.makeConstraints { make in
            make.left.right.top.equalToSuperview()
            make.bottom.equalTo(-16)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.right.equalTo(-18)
            make.top.equalTo(18)
            make.height.equalTo(24)
        }
        
        lineView.snp.makeConstraints { make in
            make.left.equalTo(0)
            make.right.equalTo(0)
            make.top.equalTo(titleLabel.snp.bottom).offset(12)
            make.height.equalTo(0.5)
        }
        
        applicantTitleLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.right.equalTo(-18)
            make.top.equalTo(lineView.snp.bottom).offset(16)
            make.height.equalTo(20)
        }
        
        applicantContentView.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.right.equalTo(-18)
            make.top.equalTo(applicantTitleLabel.snp.bottom).offset(12)
        }
        
        applicantNamesLabel.snp.makeConstraints { make in
            make.left.equalTo(14)
            make.right.equalTo(-14)
            make.top.equalTo(12)
            make.bottom.equalTo(-12)
        }
        
        submitTimeView.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.right.equalTo(-18)
            make.top.equalTo(applicantContentView.snp.bottom).offset(16)
        }
        
        leaveHKTimeView.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.right.equalTo(-18)
            make.top.equalTo(submitTimeView.snp.bottom).offset(0)
        }
        
        leaveHKSwithView.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.right.equalTo(-18)
            make.top.equalTo(leaveHKTimeView.snp.bottom)
            make.bottom.equalTo(0)
        }
    }
}
