//
//  YHCardExampleView.swift
//  galaxy
//
//  Created by EDY on 2024/1/29.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHCardExampleView: UIView {

    var centerView: UIView!
    var titleLabel: UILabel!
    var closeButton: UIButton!
    var lineView: UIView!
    var messageLabel: UILabel!
    var topImageView: UIImageView!
    var bottomImageView: UIImageView!
    var bottomButton: UIButton!
    var type: YHCardType? {
        didSet {
            guard let type = type else { return }
            switch type {
            case .identity:
                messageLabel.isHidden = false
                titleLabel.text = "身份证示例模板"
                topImageView.image = UIImage(named: "service_card_id_back")
                bottomImageView.image = UIImage(named: "service_card_id_frant")
            case .passport:
                messageLabel.isHidden = true
                titleLabel.text = "港澳通行证示例模板"
                topImageView.image = UIImage(named: "service_card_passport_frant")
                bottomImageView.image = UIImage(named: "service_card_passport_back")
                topImageView.snp.remakeConstraints { make in
                    make.left.equalTo(21)
                    make.right.equalTo(-21)
                    make.height.equalTo(207)
                    make.top.equalTo(109)
                }
            case .other: break
            }
        }
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = UIColor(white: 0.5, alpha: 0.1)
        let tap = UITapGestureRecognizer(target: self, action: #selector(handleTap))
        tap.delegate = self
        addGestureRecognizer(tap)
        setView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setView() {
        backgroundColor = UIColor(hex: 0x000000, alpha: 0.5)
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.left.right.bottom.equalToSuperview()
            make.height.equalTo(686)
        }
        
        titleLabel = {
            let label = UILabel()
            label.text = "身份证示例模板"
            label.font = UIFont.PFSC_M(ofSize: 17)
            label.textColor = UIColor.mainTextColor
            label.textAlignment = .center
            return label
        }()
        centerView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(21)
            make.right.equalTo(-21)
            make.height.equalTo(21)
            make.top.equalTo(16)
        }
        
        closeButton = {
            let button = UIButton(type: .custom)
            button.setBackgroundImage(UIImage(named: "service_card_close"), for: .normal)
            button.addTarget(self, action: #selector(dismiss), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(closeButton)
        closeButton.snp.makeConstraints { make in
            make.right.equalTo(-21)
            make.width.height.equalTo(24)
            make.top.equalTo(16)
        }
        
        lineView = {
            let view = UIView()
            view.backgroundColor = UIColor.separatorColor
            return view
        }()
        centerView.addSubview(lineView)
        lineView.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(52)
            make.height.equalTo(1)
            make.right.equalTo(-18)
        }
        
        messageLabel = {
            let label = UILabel()
            label.text = "*须使用二代身份证"
            label.font = UIFont.PFSC_R(ofSize: 14)
            label.textColor = UIColor.placeHolderColor
            label.textAlignment = .left
            label.numberOfLines = 0
            return label
        }()
        centerView.addSubview(messageLabel)
        messageLabel.snp.makeConstraints { make in
            make.left.equalTo(21)
            make.right.equalTo(-21)
            make.height.equalTo(20)
            make.top.equalTo(109)
        }
        
        topImageView = {
            let imageView = UIImageView()
            imageView.image = UIImage(named: "service_card_id_back")
            imageView.layer.cornerRadius = kCornerRadius6
            imageView.clipsToBounds = true
            return imageView
        }()
        centerView.addSubview(topImageView)
        topImageView.snp.makeConstraints { make in
            make.left.equalTo(21)
            make.right.equalTo(-21)
            make.height.equalTo(207)
            make.top.equalTo(150)
        }
        
        bottomImageView = {
            let imageView = UIImageView()
            imageView.image = UIImage(named: "service_card_passport_back")
            imageView.layer.cornerRadius = kCornerRadius6
            imageView.clipsToBounds = true
            return imageView
        }()
        centerView.addSubview(bottomImageView)
        bottomImageView.snp.makeConstraints { make in
            make.left.equalTo(21)
            make.right.equalTo(-21)
            make.height.equalTo(207)
            make.top.equalTo(topImageView.snp.bottom).offset(16)
        }
        
        bottomButton = {
            let button = UIButton(type: .custom)
            button.backgroundColor =  UIColor(hex: 0x4d9ffb)
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 16)
            button.contentHorizontalAlignment = .center
            button.setTitle("知道了", for: .normal)
            button.setTitleColor( UIColor(hex: 0xffffff), for: .normal)
            button.layer.cornerRadius = kCornerRadius3
            button.clipsToBounds = true
            button.addTarget(self, action: #selector(dismiss), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(bottomButton)
        bottomButton.snp.makeConstraints { make in
            make.right.equalTo(-21)
            make.left.equalTo(21)
            make.bottom.equalTo(-42)
            make.height.equalTo(48)
        }
        bottomButton.layoutIfNeeded()
        
        bottomButton.addYinHeGradualLayer()
        
        let array = ["四角完整", "照片清晰", "亮度均匀"]
        for i in 0 ..< array.count {
            let imageView = UIImageView()
            imageView.image = UIImage(named: "mid_image")
            centerView.addSubview(imageView)
            imageView.snp.makeConstraints { make in
                make.top.equalTo(76)
                make.left.equalTo(21 + i * 99)
                make.width.height.equalTo(14)
            }
            let label = UILabel()
            label.text = array[i]
            label.textColor = UIColor.mainTextColor
            label.font = UIFont.PFSC_R(ofSize: 14)
            centerView.addSubview(label)
            label.snp.makeConstraints { make in
                make.top.equalTo(73)
                make.left.equalTo(43 + i * 99)
                make.height.equalTo(20)
                make.width.equalTo(56)
            }
        }
    }
    
    @objc private func handleTap(_ sender: AnyObject?) {
        dismiss()
    }
    
    @objc func dismiss() {
        removeFromSuperview()
    }
}

extension YHCardExampleView: UIGestureRecognizerDelegate {
    func gestureRecognizer(_ gestureRecognizer: UIGestureRecognizer, shouldReceive touch: UITouch) -> Bool {
        if touch.view == self {
            return true
        }
        return false
    }
}
