//
//  YHGCApplicationType.swift
//  galaxy
//
//  Created by alexzzw on 2024/11/11.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import Foundation

enum YHGCApplicationType: Int {
    case typeA = 1
    case typeB = 2
    case typeC = 3
    
    var titleString: String {
        switch self {
        case .typeA:
            return "高才A类申请"
        case .typeB:
            return "高才B类申请"
        case .typeC:
            return "高才C类申请"
        }
    }
    
    var shortTitleString: String {
        switch self {
        case .typeA:
            return "高才A类"
        case .typeB:
            return "高才B类"
        case .typeC:
            return "高才C类"
        }
    }
    
    var detailString: String {
        switch self {
        case .typeA:
            return "近一年度纳税收入250万港元及以上人士"
        case .typeB:
            return "百强大学毕业，且近5年累积工作经验时长不低于3年人士"
        case .typeC:
            return "百强大学毕业不足5年，且工作经验时长不足3年人士"
        }
    }
}
