//
//  YHOneKeyLoginView.swift
//  galaxy
//
//  Created by edy on 2024/5/28.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AVFoundation

class YHOneKeyLoginView: UIView {
    
    var closeBlock: (() -> Void)?
    var changeLoginBlock: (() -> Void)?
    
    lazy var player: AVPlayer = {
        let videoURL = Bundle.main.url(forResource: "loginBkg", withExtension: "mov")!
        let player = AVPlayer(url: videoURL)
        player.actionAtItemEnd = .none
        return player
    }()
    
    lazy var playerLayer: AVPlayerLayer = {
        let playerLayer = AVPlayerLayer(player: player)
        playerLayer.frame = UIScreen.main.bounds
        playerLayer.videoGravity = .resizeAspectFill
        return playerLayer
    }()
    
    lazy var videoBgView: UIView = {
        let videoBgView = UIView(frame: UIScreen.main.bounds)
        videoBgView.layer.insertSublayer(playerLayer, at: 0)
        player.play()
        player.seek(to: .zero)
        return videoBgView
    }()

    lazy var closeButton: UIButton = {
        let button = UIButton(type: .custom)
        button.setImage(UIImage(named: "login_close"), for: .normal)
        button.addTarget(self, action: #selector(close), for: .touchUpInside)
        return button
    }()
    
    lazy var changeLoginButton: UIButton = {
        let button = UIButton(type: .custom)
        button.setTitle("其他登录方式", for: .normal)
        button.setTitleColor(.white, for: .normal)
        button.titleLabel?.font = .PFSC_R(ofSize: 14)
        button.addTarget(self, action: #selector(didChangeLoginButtonClicked), for: .touchUpInside)
        return button
    }()
    
    lazy var logoImgView: UIImageView = {
        let imageView = UIImageView()
        imageView.image = UIImage(named: "login_icon")
        imageView.isHidden = true
        return imageView
    }()
    
    lazy var loginTitleLabel: UILabel = {
        let label = UILabel()
        label.text = "欢迎来到银河港生活"
        label.font = UIFont.PFSC_B(ofSize: 30)
        label.textColor = UIColor.white
        return label
    }()
    
    lazy var loginSubTitleLabel: UILabel = {
        let label = UILabel()
        label.text = "美好新生活从这里开始"
        label.font = UIFont.PFSC_R(ofSize: 15)
        label.textColor =  UIColor(hex: 0xffffff, alpha: 0.8)
        return label
    }()
    
    @objc func close() {
        self.closeBlock?()
    }
    
    @objc func didChangeLoginButtonClicked() {
        self.changeLoginBlock?()
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    deinit {
        NotificationCenter.default.removeObserver(self)
    }
    
    func setupUI() {
        
        NotificationCenter.default.addObserver(self, selector: #selector(playerItemDidPlayToEndTimeNotification), name: AVPlayerItem.didPlayToEndTimeNotification, object: nil)
        
        self.addSubview(videoBgView)
        self.addSubview(logoImgView)
        self.addSubview(loginTitleLabel)
        self.addSubview(loginSubTitleLabel)
        self.addSubview(closeButton)
        self.addSubview(changeLoginButton)
        
        closeButton.snp.makeConstraints { make in
            make.left.equalTo(13)
            make.top.equalTo(51)
            make.width.height.equalTo(30)
        }
        
        changeLoginButton.snp.makeConstraints { make in
            make.right.equalTo(-16)
            make.height.equalTo(44)
            make.width.equalTo(86)
            make.centerY.equalTo(closeButton)
        }
        
        logoImgView.snp.makeConstraints { make in
            make.left.equalTo(24)
            make.top.equalTo(closeButton.snp.bottom).offset(32)
            make.width.equalTo(82)
            make.height.equalTo(30)
            
        }
        
        loginTitleLabel.snp.makeConstraints { make in
            make.left.equalTo(logoImgView.snp.left)
            make.right.equalTo(-24)
            make.top.equalTo(logoImgView.snp.bottom).offset(12)
            make.height.equalTo(42)
        }
        
        loginSubTitleLabel.snp.makeConstraints { make in
            make.left.equalTo(logoImgView.snp.left)
            make.right.equalTo(-24)
            make.top.equalTo(loginTitleLabel.snp.bottom).offset(4)
            make.height.equalTo(20)
        }
    }
    
    @objc func playerItemDidPlayToEndTimeNotification() {
        player.seek(to: .zero)
    }
}
