//
//  YHIncomeRecordViewModel.swift
//  galaxy
//
//  Created by alexzzw on 2024/11/18.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHIncomeRecordViewModel: YHBaseViewModel {

    func getIncomeList(orderId: Int, callback: @escaping (_ incomeModel: YHIncomeRecordCompleteModel?, _ error: YHErrorModel?) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.IncomeRecord.incomeList
        _ = YHNetRequest.getRequest(url: strUrl, params: ["order_id": orderId]) { json, _ in
            // 1. json字符串 转 对象
            printLog("model 是 ==> \(json)")

            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let resultModel = YHIncomeRecordCompleteModel.deserialize(from: dic) else {
                    let err = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    callback(nil, err)
                    return
                }
                callback(resultModel, nil)

            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callback(nil, err)
            }

        } failBlock: { err in
            callback(nil, err)
        }
    }

    func getIncomeDetail(incomeId: Int, callback: @escaping (_ companyDetail: YHIncomeCompanyDetailModel?, _ error: YHErrorModel?) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.IncomeRecord.incomeDetail
        _ = YHNetRequest.getRequest(url: strUrl, params: ["income_id": incomeId]) { json, _ in
            // 1. json字符串 转 对象
            printLog("model 是 ==> \(json)")

            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let resultModel = YHIncomeCompanyDetailModel.deserialize(from: dic) else {
                    let err = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    callback(nil, err)
                    return
                }
                callback(resultModel, nil)

            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callback(nil, err)
            }

        } failBlock: { err in
            callback(nil, err)
        }
    }

    func updateDetail(incomeId: Int, incomeMoney: Double, corporateTurnover: Double, incomeType: [Int], hasAllFile: Int, callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let params: [String: Any] = ["income_id": incomeId,
                                     "income_money": incomeMoney,
                                     "corporate_turnover": corporateTurnover,
                                     "income_type": incomeType,
                                     "has_all_file": hasAllFile]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.IncomeRecord.updateDetail
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { json, _ in
            // 1. json字符串 转 对象
            printLog("model 是 ==> \(json)")
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callBackBlock(false, err)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }

    func incomeUpdate(orderId: Int, incomeOver100: Int, type: YHIncomeRecordUpdateType, callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let params: [String: Any] = ["order_id": orderId,
                                     "income_over_100": incomeOver100,
                                     "type": type.rawValue]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.IncomeRecord.incomeUpdate
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { json, _ in
            // 1. json字符串 转 对象
            printLog("model 是 ==> \(json)")
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callBackBlock(false, err)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
}
