//
//  YHBottomNextView.swift
//  galaxy
//
//  Created by EDY on 2024/1/25.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHBottomNextView: UIView {
    typealias Block = () -> Void
    var nextblock: Block?
    var saveBlock: Block?
    var saveButton: UIButton!
    var nextButton: UIButton!
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = .white
        setUpView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setUpView() {
        saveButton = {
            let button = UIButton(type: .custom)
            button.backgroundColor =  UIColor.contentBkgColor
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 15)
            button.contentHorizontalAlignment = .center
            button.setTitle("保存", for: .normal)
            button.setTitleColor( UIColor.mainTextColor, for: .normal)
            button.layer.cornerRadius = kCornerRadius3
            button.addTarget(self, action: #selector(save), for: .touchUpInside)
            return button
        }()
        addSubview(saveButton)
        saveButton.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.top.equalTo(10)
            make.height.equalTo(44)
            make.width.equalTo(86)
        }
        
        nextButton = {
            let button = UIButton(type: .custom)
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 15)
            button.contentHorizontalAlignment = .center
            button.setTitle("下一步", for: .normal)
            button.setTitleColor( UIColor(hex: 0xffffff), for: .normal)
            button.layer.cornerRadius = kCornerRadius3
            button.clipsToBounds = true
            button.addTarget(self, action: #selector(goNext), for: .touchUpInside)
            return button
        }()
        addSubview(nextButton)
        nextButton.snp.makeConstraints { make in
            make.right.equalTo(-16)
            make.top.equalTo(10)
            make.height.equalTo(44)
            make.left.equalTo(saveButton.snp.right).offset(10)
        }
    }
    
    @objc func save() {
        if let block = saveBlock {
            block()
        }
    }
    
    @objc func goNext() {
        if let block = nextblock {
            block()
        }
    }
}
