//
//  YHHKRecordsEditButtonCell.swift
//  galaxy
//
//  Created by alexzzw on 2024/9/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHHKRecordsEditButtonCell: YHResignDocumentCell {

    static let cellReuseIdentifier = "YHHKRecordsEditButtonCell"
    
    private lazy var centerLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_M(ofSize: 14)
        label.textColor = .brandMainColor
        return label
    }()
    
    private lazy var topLineView: UIView = {
        let view = UIView()
        view.backgroundColor = .separatorColor
        return view
    }()

    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupCellInfo(title: String?) {
        centerLabel.text = title
    }
    
}

extension YHHKRecordsEditButtonCell {
    
    private func setupUI() {
        updateCellCorner(.bottom)
        subContainerView.addSubview(centerLabel)
        subContainerView.addSubview(topLineView)
                
        topLineView.snp.makeConstraints { make in
            make.top.equalToSuperview()
            make.left.equalToSuperview()
            make.right.equalToSuperview()
            make.height.equalTo(0.5)
        }
        
        centerLabel.snp.makeConstraints { make in
            make.center.equalToSuperview()
        }
    }
}
