//
//  YHMakePlanCusttomHeadView.swift
//  galaxy
//
//  Created by EDY on 2025/3/27.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHMakePlanCusttomHeadView: UIView {
    typealias Block = (Int) -> Void
    var block: Block?
    private let tabs = ["基础身份", "工作联系", "生活联系", "投资联系"]
    private var buttons: [UIButton] = []
    private var selectedIndex: Int = 0
    
    // UI Components
    private lazy var stackView: UIStackView = {
        let stack = UIStackView()
        stack.axis = .horizontal
        stack.distribution = .fillEqually
        return stack
    }()
    
    private let underlineView: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor.mainTextColor
        return view
    }()
    
    // MARK: - Initialization
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
        setupConstraints()
    }
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
        setupUI()
        setupConstraints()
    }
    
    // MARK: - Setup
    private func setupUI() {
        backgroundColor = .systemBackground
        
        // Create buttons
        tabs.enumerated().forEach { index, title in
            let button = UIButton(type: .system)
            button.setTitle(title, for: .normal)
            if index == 0 {
                button.titleLabel?.font = UIFont.PFSC_M(ofSize: 16)
            } else {
                button.titleLabel?.font = UIFont.PFSC_R(ofSize: 16)
            }
            button.setTitleColor(index == 0 ? UIColor.mainTextColor: UIColor(hex: 0x6a7586), for: .normal)
            button.tag = index
            button.addTarget(self, action: #selector(tabTapped(_:)), for: .touchUpInside)
            buttons.append(button)
            stackView.addArrangedSubview(button)
        }
        
        addSubview(stackView)
        addSubview(underlineView)
    }
    
    private func setupConstraints() {
        stackView.snp.makeConstraints { make in
            make.top.equalToSuperview()
            make.leading.trailing.equalToSuperview()
            make.height.equalTo(40)
        }
        
        underlineView.snp.makeConstraints { make in
            make.top.equalTo(stackView.snp.bottom)
            make.height.equalTo(2)
            make.width.equalTo(16)
            make.centerX.equalTo(buttons[0].snp.centerX)
        }
    }
    
    // MARK: - Actions
    @objc private func tabTapped(_ sender: UIButton) {
        let newIndex = sender.tag
        guard newIndex != selectedIndex else { return }
        
        // Update colors
        buttons[selectedIndex].setTitleColor(UIColor(hex: 0x6a7586), for: .normal)
        buttons[selectedIndex].titleLabel?.font = UIFont.PFSC_R(ofSize: 16)
        buttons[newIndex].titleLabel?.font = UIFont.PFSC_M(ofSize: 16)
        buttons[newIndex].setTitleColor(UIColor.mainTextColor, for: .normal)
        
        // Animate underline
        UIView.animate(withDuration: 0.3) {
            self.underlineView.snp.remakeConstraints { make in
                make.top.equalTo(self.stackView.snp.bottom)
                make.height.equalTo(2)
                make.width.equalTo(16)
                make.centerX.equalTo(self.buttons[newIndex].snp.centerX)
            }
            self.layoutIfNeeded()
        }
        
        selectedIndex = newIndex
        self.block?(selectedIndex)
    }
    
    func updataData(_ tag: Int) {
        let newIndex = tag
        guard newIndex != selectedIndex else { return }
        
        // Update colors
        buttons[selectedIndex].setTitleColor(UIColor(hex: 0x6a7586), for: .normal)
        buttons[selectedIndex].titleLabel?.font = UIFont.PFSC_R(ofSize: 16)
        buttons[newIndex].titleLabel?.font = UIFont.PFSC_M(ofSize: 16)
        buttons[newIndex].setTitleColor(UIColor.mainTextColor, for: .normal)
        
        // Animate underline
        UIView.animate(withDuration: 0.3) {
            self.underlineView.snp.remakeConstraints { make in
                make.top.equalTo(self.stackView.snp.bottom)
                make.height.equalTo(2)
                make.width.equalTo(16)
                make.centerX.equalTo(self.buttons[newIndex].snp.centerX)
            }
            self.layoutIfNeeded()
        }
        
        selectedIndex = newIndex
    }
}
