//
//  YHPlanCustomerCaseCollectionCell.swift
//  galaxy
//
//  Created by Dufet on 2025/3/26.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHPlanCustomerCaseCollectionCell: UICollectionViewCell {
    
    static let cellReuseIdentifier = "YHPlanCustomerCaseCollectionCell"

    var model = YHPlanCaseModel() {
        didSet {
            descLabel.text = model.title
            
            if let url = URL(string: model.img_url) {
                iconImgV.sd_setImage(with: url, placeholderImage: UIImage(named: "global_default_image"))
            } else {
                iconImgV.image = UIImage(named: "global_default_image")
            }
        }
    }
    
    lazy var whiteContentView: UIView = {
        let v = UIView()
        v.backgroundColor = .white
        v.layer.cornerRadius = 6.0
        v.clipsToBounds = true
        return v
    }()
    
    lazy var iconImgV: UIImageView = {
        let v = UIImageView()
        v.backgroundColor = .red
        return v
    }()
    
    lazy var descLabel: UILabel = {
        let lable = UILabel()
        lable.textColor = UIColor.mainTextColor
        lable.textAlignment = .left
        lable.font = UIFont.PFSC_R(ofSize: 14)
        lable.numberOfLines = 0
        lable.text = "啊所发生的发生的法师打发三大发啥打法是都发啥打法是打发撒打发三大发啥打法啊所发生的发生的法师打发三大发啥打法是都发啥打法是打发撒打发三大发啥打法"
        return lable
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }

    private func setupUI() {
        
        contentView.addSubview(whiteContentView)
        whiteContentView.addSubview(iconImgV)
        whiteContentView.addSubview(descLabel)
        
        whiteContentView.snp.makeConstraints { make in
            make.top.left.right.equalToSuperview()
            make.bottom.equalTo(-10)
        }
        
        iconImgV.snp.makeConstraints { make in
            make.left.right.top.equalToSuperview()
            make.height.equalTo(iconImgV.snp.width).multipliedBy(200.0/166.0)
        }
        
        descLabel.snp.makeConstraints { make in
            make.top.equalTo(iconImgV.snp.bottom).offset(8)
            make.bottom.equalTo(-12)
            make.left.equalTo(8)
            make.right.equalTo(-8)
        }
    }
}
