//
//  YHCheckEamilAlertView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/3/31.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHCheckEamilAlertView: UIView {
    typealias AgreeBlock = () -> Void
    var agreeBlock: AgreeBlock?
    var centerView: UIView!
    var titleLabel: UILabel!
    var messageLabel: UILabel!
    var agreeButton: UIButton!
    var disAgressButton: UIButton!
    
    static func show(_ title: String? = nil, _ message: String? = nil, _ leftButtonString: String? = nil, _ rightButtonString: String? = nil, _ textAlignment: NSTextAlignment = .left, callBack: @escaping (() -> Void)) {
        let view = YHCheckEamilAlertView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: KScreenHeight))
        view.agreeBlock = callBack
        view.setContent(title, message, leftButtonString, rightButtonString)
        view.messageLabel.textAlignment = textAlignment
        let window = UIApplication.shared.yhKeyWindow()
        window?.addSubview(view)
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = UIColor(white: 0.5, alpha: 0.1)
        let tap = UITapGestureRecognizer(target: self, action: #selector(handleTap))
        tap.delegate = self
        addGestureRecognizer(tap)
        setView()
    }

    func setContent(_ title: String? = nil, _ message: String? = nil, _ leftButtonString: String? = nil, _ rightButtonString: String? = nil) {
        self.titleLabel.text = title
//        self.messageLabel.text = message
        let a: ASAttributedString = .init("请确认接收邮箱是否为\n", .font(UIFont.PFSC_R(ofSize: 16)), .foreground(UIColor.mainTextColor))
        let aa: ASAttributedString = .init(NSAttributedString(string: message ?? "--"), .font(UIFont.PFSC_R(ofSize: 16)), .foreground(UIColor.brandMainColor))
        self.messageLabel.attributed.text = a + aa
        
        self.disAgressButton.setTitle(leftButtonString, for: .normal)
        self.agreeButton.setTitle(rightButtonString, for: .normal)
        
        if title?.count == 0 || title == nil {
            centerView.snp.remakeConstraints { make in
                make.center.equalToSuperview()
                make.width.equalTo(299)
            }
            
            messageLabel.snp.remakeConstraints { make in
                make.left.equalTo(22)
                make.right.equalTo(-22)
                make.top.equalTo(40)
                make.bottom.equalTo(disAgressButton.snp.top).offset(-18)
            }
            
            disAgressButton.snp.removeConstraints()
            disAgressButton.snp.remakeConstraints { make in
                make.top.equalTo(messageLabel.snp.bottom).offset(19)
                make.left.equalTo(16)
                make.width.equalTo(128)
                make.height.equalTo(45)
                make.bottom.equalTo(-16)
            }
            
            agreeButton.snp.removeConstraints()
            agreeButton.snp.remakeConstraints { make in
                make.right.equalTo(-16)
                make.width.equalTo(128)
                make.height.equalTo(45)
                make.top.equalTo(disAgressButton)
            }
            
        }
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setView() {
        backgroundColor = UIColor(hex: 0x0000, alpha: 0.5)
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.center.equalToSuperview()
            make.width.equalTo(299)
            make.height.equalTo(187)
        }
        
        titleLabel = {
            let label = UILabel()
//            label.textAlignment = .center
            label.textColor = UIColor.mainTextColor
            label.font = UIFont.PFSC_M(ofSize: 17)
            label.numberOfLines = 0
            return label
        }()
        
        centerView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(22)
            make.right.equalTo(-22)
            make.height.equalTo(20)
            make.top.equalTo(16)
        }
        
        messageLabel = {
            let label = UILabel()
//            label.textAlignment = .center
            label.textColor = UIColor.mainTextColor
            label.font = UIFont.PFSC_R(ofSize: 16)
            label.numberOfLines = 0
            return label
        }()
        
        centerView.addSubview(messageLabel)
        messageLabel.snp.makeConstraints { make in
            make.left.equalTo(22)
            make.right.equalTo(-22)
            make.height.equalTo(42)
            make.top.equalTo(63)
        }
        
        disAgressButton = {
            let button = UIButton(type: .custom)
            button.backgroundColor =  UIColor(hex: 0xffffff)
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 15)
            button.contentHorizontalAlignment = .center
            button.setTitle("不同意", for: .normal)
            button.setTitleColor( UIColor.brandMainColor, for: .normal)
            button.layer.cornerRadius = kCornerRadius3
            button.layer.borderWidth = 1
            button.layer.borderColor = UIColor.brandMainColor.cgColor
            button.addTarget(self, action: #selector(disagree), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(disAgressButton)
        disAgressButton.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.bottom.equalTo(-21)
            make.width.equalTo(128)
            make.height.equalTo(45)
        }
        
        agreeButton = {
            let button = UIButton(type: .custom)
            button.backgroundColor =  UIColor.brandMainColor
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 15)
            button.contentHorizontalAlignment = .center
            button.setTitle("同意", for: .normal)
            button.setTitleColor( UIColor(hex: 0xffffff), for: .normal)
            button.layer.cornerRadius = kCornerRadius3
            button.addTarget(self, action: #selector(agree), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(agreeButton)
        agreeButton.snp.makeConstraints { make in
            make.right.equalTo(-16)
            make.bottom.equalTo(-21)
            make.width.equalTo(128)
            make.height.equalTo(45)
        }
        
    }
    
    @objc func agree() {
        if let block = self.agreeBlock {
            block()
        }
        dismiss()
    }
    
    @objc private func handleTap(_ sender: AnyObject?) {
        dismiss()
    }
    
    @objc func disagree() {
        dismiss()
    }
    
    func dismiss() {
        removeFromSuperview()
    }
}

extension YHCheckEamilAlertView: UIGestureRecognizerDelegate {
    func gestureRecognizer(_ gestureRecognizer: UIGestureRecognizer, shouldReceive touch: UITouch) -> Bool {
        if touch.view == self {
            return true
        }
        return false
    }
}
