//
//  YHPreviewInfoSectionHeaderCell.swift
//  galaxy
//
//  Created by alexzzw on 2024/11/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHPreviewInfoSectionHeaderCell: YHResignDocumentCell {

    static let cellReuseIdentifier = "YHPreviewInfoSectionHeaderCell"
    
    private lazy var infoNameLabel: UILabel = {
        let label = UILabel(text: "--")
        label.textColor = UIColor.mainTextColor
        label.font = UIFont.PFSC_M(ofSize: 14)
        return label
    }()
    
    private lazy var lineView: UIView = {
        let view = UIView()
        view.backgroundColor = .separatorColor
        return view
    }()
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setup(title: String) {
        infoNameLabel.text = title
    }
    
    private func setupUI() {
        updateCellCorner(.mid)
        subContainerView.addSubview(infoNameLabel)
        subContainerView.addSubview(lineView)
        infoNameLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(18)
            make.top.equalToSuperview().offset(16)
            make.bottom.equalToSuperview().offset(-8)
            make.right.lessThanOrEqualToSuperview().offset(-18)
        }
        
        lineView.snp.makeConstraints { make in
            make.left.equalTo(infoNameLabel)
            make.right.equalToSuperview().offset(-18)
            make.top.equalToSuperview()
            make.height.equalTo(0.5)
        }
    }

}
