//
//  YHHeadView.swift
//  galaxy
//
//  Created by EDY on 2024/7/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHHeadView: UIView {
    var imageView = UIImageView()
    var titleLabel: UILabel!
    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = .white
        setUpView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setUpView() {
        addSubview(imageView)
        imageView.snp.makeConstraints { make in
            make.top.left.right.equalToSuperview()
            make.height.equalTo(510)
        }
        
        titleLabel = {
            let label = UILabel()
            label.textColor = UIColor.mainTextColor
            label.font = UIFont.PFSC_M(ofSize: 21)
            label.text = "内景展示"
            return label
        }()
        addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(20)
            make.top.equalTo(imageView.snp.bottom).offset(32)
            make.height.equalTo(29)
        }
    }
    
}
