//
//  YHMaterialListModel.swift
//  galaxy
//
//  Created by edy on 2024/9/10.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SmartCodable

enum YHMaterialType: String {
    // 资料类型(CERT=证件资料  WORK=工作资料  LIVE=生活资料)
    case cer = "CERT"
    case work = "WORK"
    case live = "LIVE"
}

enum YHMaterialStatus: String {
    case all = "ALL" // 自定义
    // (未开始=NOT_OPEN 待上传=TO_BE_UPLOAD  待审核= PENDING_AUDIT  已驳回=REJECTED  已完成= COMPLETED)
    case unOpen = "NOT_OPEN"
    case preUpload = "TO_BE_UPLOAD"
    case review = "PENDING_AUDIT"
    case rejected = "REJECTED"
    case completed = "COMPLETED"
}

class YHMaterialListModel: SmartCodable {

    var id: Int = 0
    var order_sn: String = ""
    var status: String = ""
    var stay_deadline: String = ""
    var material: [YHMaterialModel] = []
    var members: [YHMembersModel] = []
    
    required init() {
        
    }
}

class YHMaterialModel: SmartCodable {
    
    var id: Int = 0
    var renewal_id: Int = 0
    var order_id: Int = 0
    var subset_id: Int = 0
    var information_id: Int = 0
    var template_id: Int = 0
    var relation: Int = 0
    // 资料类型(CERT=证件资料  WORK=工作资料  LIVE=生活资料)
    var mtype: String = ""
    var name: String = ""
    var info: [YHMaterialModelItemModel] = []
    var upload_require: String = ""
    var audit_at: String = ""
    var audit_uid: Int = 0
    // 状态(待上传=TO_BE_UPLOAD  待审核= PENDING_AUDIT  已驳回=REJECTED  已完成= COMPLETED)
    var status: String = ""
    var remark: String = ""
    var audit_remark: String = ""
    var created_at: String = ""
    var updated_at: String = ""
    var deleted_at: String = ""
    
    func getName() -> String {
        var nameStr = name.trimmingCharacters(in: .whitespaces)
        nameStr = nameStr.replacingOccurrences(of: "\n", with: "")
        nameStr = nameStr.replacingOccurrences(of: "\r", with: "")
        return nameStr
    }

    required init() {
        
    }
}

class YHMembersModel: SmartCodable {
    
    var id: Int = 0
    var renewal_number: Int = 0
    var apply_name: String = ""
    var apply_relation: Int = 0
    var apply_relation_text: String = ""
    
    required init() {
        
    }
}

class YHResignTemplateDetail: SmartCodable {
    
    var id: Int = 0
    var type: Int = 0
    var name: String = ""
    var remark: String = ""
    var file_url: [YHResignTemplateItemModel] = []
    
    func getName() -> String {
        var nameStr = name.trimmingCharacters(in: .whitespaces)
        nameStr = nameStr.replacingOccurrences(of: "\n", with: "")
        nameStr = nameStr.replacingOccurrences(of: "\r", with: "")
        return nameStr
    }
        
    required init() {
        
    }
}

class YHResignTemplateItemModel: SmartCodable {
    
    var name: String = ""
    var fileUrl: String = ""
    
    required init() {
        
    }
}

class YHMaterialModelItemModel: SmartCodable {
    
    var uid: String = ""
    var url: String = ""
    var name: String = ""
    var naming: String = ""
    var status: String = ""
    var updated_at: String = ""
    
    var size: String = ""
    var type: String = ""
    
    // 获取文件后缀名 eg:123.pdf -> pdf
    func getFileSuffixName() -> String {
        let res1 = url.pathExtension.lowercased()
        if !res1.isEmpty {
            return res1
        }
        let res2 = name.pathExtension.lowercased()
        if !res2.isEmpty {
            return res2
        }
        return ""
    }
    
    // 获取文件名(不包含后缀) eg:123.pdf -> 123
    func getFileNameWithoutSuffix() -> String {
        if name.isEmpty {
            return name
        }
        if !name.contains(".") {
            return name
        }
        if !name.pathExtension.isEmpty {
          let fileName = (name as NSString).deletingPathExtension
          return fileName
        }
        return ""
    }
    
    required init() {
        
    }
}
