//
//  YHActivityTwoItemView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/6/21.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHActivityTwoItemView: UIView {
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }
    
    
    lazy var titleLable:UILabel = {
        let label = UILabel()
        label.textColor = UIColor.mainTextColor50
        label.textAlignment = .left
        label.font = UIFont.PFSC_R(ofSize:14)
        label.text = ""
//        label.numberOfLines = 0
        return label
    }()
    
    
    lazy var detailLable:UILabel = {
        let label = UILabel()
        label.textColor = UIColor.mainTextColor
        label.textAlignment = .right
        label.font = UIFont.PFSC_R(ofSize:14)
        label.text = ""
        label.numberOfLines = 0
        return label
    }()
    
    
    func updateItem(title : String, value : String) {
        titleLable.text = title
        detailLable.text = value
    }
}

extension YHActivityTwoItemView {
    func setupUI() {
        
        addSubview(titleLable)
        addSubview(detailLable)
        
        titleLable.snp.makeConstraints { make in
            make.top.left.equalToSuperview()
            make.width.equalTo(56)
        }
        
        
        detailLable.snp.makeConstraints { make in
            make.top.equalTo(titleLable.snp.top)
            make.left.equalTo(titleLable.snp.right).offset(20)
            make.right.equalToSuperview()
            
            make.bottom.equalToSuperview()
        }
    }
}
