//
//  YHNameCardInfoView.swift
//  galaxy
//
//  Created by edy on 2024/6/18.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import DragCardContainer

class YHNameCardInfoView: DragCardView {

    static let height = 456.0
    static let width = KScreenWidth-36.0*2
    let headWidth = 104.0
    var sendBlock:((String?)->())?

    var userModel:YHMatchUserInfo = YHMatchUserInfo()  {
        didSet {
            if let url = URL(string: self.userModel.avatar) {
                self.headImgV.kf.setImage(with: url, placeholder: UIImage(named: "people_head_default"))
            } else {
                self.headImgV.image = UIImage(named: "people_head_default")
            }
            self.nameLabel.text = self.userModel.username
            var resultArr:[String] = []
            
            // 城市文字
            let cityStr = self.userModel.address.showCity()
            if !cityStr.isEmpty {
                resultArr.append(cityStr)
            }
            
            // 职位
            if !self.userModel.position.isEmpty {
                resultArr.append(self.userModel.position)
            }
            
            // 行业
            if !self.userModel.industry.isEmpty {
                resultArr.append(self.userModel.industry)
            }
            var resultStr = ""
            if resultArr.count > 0 {
                resultStr = resultArr.joined(separator: " | ")
            }
        
            self.professionalLabel.text = resultStr
            let detail = self.userModel.signature
            self.detailLabel.text = detail
            self.grayContentView.isHidden = detail.isEmpty
            var detailHeight = self.getHeight(text: detail, font: UIFont.PFSC_R(ofSize:13), width: Self.width-18.0*2-16.0*2)
            if detailHeight < 20.0 {
                detailHeight = 20.0
            } else if detailHeight > 40.0 {
                detailHeight = 40.0
            }
            self.detailLabel.snp.updateConstraints { make in
                make.height.equalTo(detailHeight)
            }
            self.signImgV.isHidden = !self.userModel.isSign

            if self.userModel.isSendRequest {
                self.bottomBtn.setTitle("已发送好友申请", for: .normal)
                self.bottomBtn.alpha = 0.3
                self.bottomBtn.isUserInteractionEnabled = false
            } else {
                self.bottomBtn.setTitle("交换名片", for: .normal)
                self.bottomBtn.alpha = 1.0
                self.bottomBtn.isUserInteractionEnabled = true
            }
            self.setNeedsLayout()
            self.layoutIfNeeded()
            
        }
    }
    
    lazy var bgImgV:UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "people_card_head_bg")
        return view
    }()
    
    lazy var headImgV:UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "people_head_default")
        view.layer.cornerRadius = self.headWidth/2.0
        view.contentMode = .scaleAspectFill
        view.clipsToBounds = true
        return view
    }()
    
    lazy var headBackImgV:UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "people_user_head_back")
        return view
    }()
    
    lazy var headBgImgV:UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "people_user_head_bg")
        view.contentMode = .scaleToFill
        return view
    }()
    
    lazy var signImgV:UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "people_sign")
        return view
    }()
    
    lazy var nameLabel:UILabel = {
        let nameLabel = UILabel()
        nameLabel.textAlignment = .center
        nameLabel.textColor = UIColor.mainTextColor
        nameLabel.font = UIFont.PFSC_M(ofSize:21)
        return nameLabel
    }()
    
    lazy var professionalLabel:UILabel = {
        let label = UILabel()
        label.textAlignment = .center
        label.textColor = UIColor.mainTextColor70
        label.font = UIFont.PFSC_R(ofSize:14)
        label.numberOfLines = 2
        return label
    }()
    
    lazy var grayContentView:UIView = {
        let view = UIView()
        view.backgroundColor = UIColor(hex: 0xF4F6FA)
        view.layer.cornerRadius = 3.0
        return view
    }()
    
    lazy var detailLabel:UILabel = {
        let label = UILabel()
        label.textColor = UIColor.mainTextColor50
        label.textAlignment = .left
        label.font = UIFont.PFSC_R(ofSize:13)
        label.numberOfLines = 2
        return label
    }()
    
    lazy var bottomBtn:UIButton = {
        let btn = UIButton()
        btn.setBackgroundImage(UIImage(named: "people_exchange_btn"), for: .normal)
        btn.setTitle("交换名片", for: .normal)
        btn.setTitleColor(.white, for: .normal)
        btn.titleLabel?.font = .PFSC_M(ofSize: 15)
        btn.layer.cornerRadius = 3.0
        btn.addTarget(self, action: #selector(didBottomBtnClicked), for: .touchUpInside)
        return btn
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        initUI()
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    @objc func didBottomBtnClicked() {
       let view = YHFriendRequestView.createView()
       view.userModel = self.userModel
       view.sendBlock = {
           [weak self] text in
           guard let self = self else { return }
           self.sendBlock?(text)
       }
       view.show()
    }
    
    static func createCardView() -> YHNameCardInfoView {
        let view = YHNameCardInfoView(frame: CGRect(x: 0, y: 0, width: Self.width, height: Self.height))
        return view
    }
    
    func show() {
        self.center = CGPointMake(KScreenWidth/2.0, KScreenHeight/2.0)
        UIApplication.shared.yhKeyWindow()?.addSubview(self)
        
    }
    
    private func initUI() {
        self.backgroundColor = .white
        self.layer.cornerRadius = 6.0
        self.clipsToBounds = true
    }
    
    private func setupUI() {
        
        self.contentView.addSubview(self.bgImgV)
        
        self.contentView.addSubview(self.headImgV)
        self.contentView.addSubview(self.headBackImgV)
        self.contentView.addSubview(self.headBgImgV)
        self.contentView.addSubview(self.signImgV)
        self.contentView.addSubview(self.nameLabel)
        self.contentView.addSubview(self.professionalLabel)
        self.contentView.addSubview(self.grayContentView)
        grayContentView.addSubview(self.detailLabel)
        self.contentView.addSubview(self.bottomBtn)
        
        self.bgImgV.snp.makeConstraints { make in
            make.left.top.right.equalToSuperview()
            make.height.equalTo(180)
        }
        
        self.headImgV.snp.makeConstraints { make in
            make.width.height.equalTo(self.headWidth)
            make.centerX.equalToSuperview()
            make.bottom.equalTo(self.bgImgV).offset(20)
        }
        self.headBgImgV.snp.makeConstraints { make in
            make.width.height.equalTo(self.headWidth)
            make.center.equalTo(self.headImgV)
        }
        self.headBackImgV.snp.makeConstraints { make in
            make.width.height.equalTo(self.headWidth+4)
            make.center.equalTo(self.headImgV)
        }
        self.signImgV.snp.makeConstraints { make in
            make.centerX.equalTo(self.headImgV)
            make.width.equalTo(49)
            make.height.equalTo(17)
            make.bottom.equalTo(self.headBgImgV)
        }
        
        self.nameLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.right.equalTo(-18)
            make.height.equalTo(30)
            make.top.equalTo(self.signImgV.snp.bottom).offset(10)
            make.centerX.equalToSuperview()
        }
        
        self.professionalLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.right.equalTo(-18)
            make.height.lessThanOrEqualTo(40.0)
            make.top.equalTo(self.nameLabel.snp.bottom).offset(8)
        }
        
        self.grayContentView.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.right.equalTo(-18)
            make.top.equalTo(self.professionalLabel.snp.bottom).offset(10)
        }
        
        self.detailLabel.snp.makeConstraints { make in
            make.left.top.equalTo(16)
            make.height.equalTo(20.0)
            make.right.bottom.equalTo(-16)
        }

        self.bottomBtn.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.right.equalTo(-18)
            make.height.equalTo(46)
            make.bottom.equalToSuperview().offset(-30)
        }
    }
    
    func getHeight(text:String, font:UIFont, width:CGFloat)->CGFloat {
        let size = CGSize.init(width:width , height: CGFloat(MAXFLOAT))
        let dic = [NSAttributedString.Key.font: font]
        let strSize = text.boundingRect(with: size, options: [.usesLineFragmentOrigin], attributes: dic, context:nil).size
        return CGSizeMake(strSize.width, ceil(strSize.height)).height
    }
}
