//
//  YHPeopleSuccessView.swift
//  galaxy
//
//  Created by EDY on 2024/6/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHPeopleSuccessView: UIView {
    var centerView: UIView!
    var titleLabel: UILabel!
    var closeButton: UIButton!
    var messageLabel: UILabel!
    var bottomImageView: UIImageView!
    var bottomButton: UIButton!

    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = UIColor(white: 0.5, alpha: 0.1)
        let tap = UITapGestureRecognizer(target: self, action: #selector(handleTap))
        tap.delegate = self
        addGestureRecognizer(tap)
        setView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setView() {
        backgroundColor = UIColor(hex: 0x000000, alpha: 0.5)
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.center.equalToSuperview()
            make.height.equalTo(273)
            make.width.equalTo(299)
        }
        
        titleLabel = {
            let label = UILabel()
            label.text = "Hi，王凤姣\n您的人脉网络已激活"
            label.font = UIFont.PFSC_M(ofSize: 17)
            label.textColor = UIColor.mainTextColor
            label.textAlignment = .center
            label.numberOfLines = 0
            return label
        }()
        centerView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(21)
            make.right.equalTo(-21)
            make.height.equalTo(48)
            make.top.equalTo(40)
        }
        
        closeButton = {
            let button = UIButton(type: .custom)
            button.setBackgroundImage(UIImage(named: "service_card_close"), for: .normal)
            button.addTarget(self, action: #selector(dismiss), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(closeButton)
        closeButton.snp.makeConstraints { make in
            make.right.equalTo(-21)
            make.width.height.equalTo(24)
            make.top.equalTo(16)
        }
        
        messageLabel = {
            let label = UILabel()
            label.text = "我们已为您智能匹配新人脉"
            label.font = UIFont.PFSC_R(ofSize: 14)
            label.textColor = UIColor.placeHolderColor
            label.textAlignment = .center
            label.numberOfLines = 0
            return label
        }()
        centerView.addSubview(messageLabel)
        messageLabel.snp.makeConstraints { make in
            make.left.equalTo(21)
            make.right.equalTo(-21)
            make.top.equalTo(96)
        }
        
        bottomImageView = {
            let imageView = UIImageView()
            imageView.image = UIImage(named: "people_success_alert_bg_image")
            imageView.layer.cornerRadius = kCornerRadius6
            imageView.clipsToBounds = true
            return imageView
        }()
        centerView.addSubview(bottomImageView)
        bottomImageView.snp.makeConstraints { make in
            make.width.equalTo(164)
            make.centerX.equalToSuperview()
            make.height.equalTo(40)
            make.top.equalTo(136)
        }
        
        bottomButton = {
            let button = UIButton(type: .custom)
            button.backgroundColor =  UIColor(hex:0x4d9ffb)
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 16)
            button.contentHorizontalAlignment = .center
            button.setTitle("去看看", for: .normal)
            button.setTitleColor( UIColor(hex:0xffffff), for: .normal)
            button.layer.cornerRadius = kCornerRadius3
            button.clipsToBounds = true
            button.addTarget(self, action: #selector(toLookPeople), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(bottomButton)
        bottomButton.snp.makeConstraints { make in
            make.right.equalTo(-16)
            make.left.equalTo(16)
            make.bottom.equalTo(-16)
            make.height.equalTo(45)
        }
        bottomButton.layoutIfNeeded()
        
        bottomButton.addYinHeGradualLayer()
    }
    
    @objc private func handleTap(_ sender: AnyObject?) {
        print("处理点击手势")
        dismiss()
    }
    
    @objc func dismiss() {
        removeFromSuperview()
    }
    
    @objc func toLookPeople() {
        NotificationCenter.default.post(name: YhConstant.YhNotification.didLookPeopleSuccessNotifiction, object: nil)
        dismiss()
    }
}

extension YHPeopleSuccessView: UIGestureRecognizerDelegate {
    func gestureRecognizer(_ gestureRecognizer:UIGestureRecognizer, shouldReceive touch:UITouch) -> Bool {
        if touch.view == self {
            return true
        }
        return false
    }
}
