//
//  YHMatchUserViewModel.swift
//  galaxy
//
//  Created by edy on 2024/6/24.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHMatchUserViewModel: NSObject {
    
    var matchUserArr:[YHMatchUserInfo?] = []
    var nameCardInfo: YHUserNameCardInfo = YHUserNameCardInfo()
    var friendListModel:YHFriendListModel = YHFriendListModel()
    var setModel: YHMainUserInformationSetModel = YHMainUserInformationSetModel()
    
    func getMatchUserlist(_ callBack: @escaping (_ success: Bool,_ error: YHErrorModel?)->()) {
        let params = ["page_size" : 5]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.People.matchUserListApi
        let _ = YHNetRequest.getRequest(url: strUrl, params: params) {
            [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            
            if json.code == 200 {
                guard let dic = json.data?.peel as?  [Any],let resultModel = [YHMatchUserInfo].deserialize(from: dic) else {
                    let err = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    self.matchUserArr = []
                    callBack(false, err)
                    return
                }
                self.matchUserArr = resultModel
                callBack(true, nil)
                
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                self.matchUserArr = []
                callBack(false, error)
            }
            
        } failBlock: { err in
            self.matchUserArr = []
            callBack(false, err)
        }
    }
    
    func addFriendWithText(_ text: String, yhId: String, callBack: @escaping (_ success: Bool,_ error: YHErrorModel?)->()) {
        
        let params = ["verify_info" : text,
                      "yh_id": yhId] as [String : Any]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.People.addFriendApi
        let _ = YHNetRequest.postRequest(url: strUrl, params: params) {
            [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            printLog(json)
            
            if json.code == 200 {
                callBack(true, nil)
            }  else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBack(false, error)
            }
        } failBlock: { err in
            callBack(false, err)
        }
    }
    
    func getMyFriendList(callBack: @escaping (_ success: Bool,_ error: YHErrorModel?)->()) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.People.friendListApi
        let _ = YHNetRequest.getRequest(url: strUrl) {
            [weak self] json, code in
            guard let self = self else { return }
            printLog("model 是 ==> \(json)")
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String : Any], let result = YHFriendListModel.deserialize(from: dic) else {
                    let error = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    self.friendListModel = YHFriendListModel()
                    callBack(false, error)
                    return
                }
                self.friendListModel = result
                callBack(true, nil)
                
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                self.friendListModel = YHFriendListModel()
                callBack(false, error)
            }
            
        } failBlock: { error in
            self.friendListModel = YHFriendListModel()
            callBack(false, error)
        }
    }
    
    func getUserNameCardInfo(uid: String, callBack: @escaping (_ success: Bool,_ error: YHErrorModel?)->()) {
        let params = ["uid" : uid]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.People.nameCardInfoApi
        let _ = YHNetRequest.getRequest(url: strUrl, params: params) {
            [weak self] json, code in
            guard let self = self else { return }
            printLog("model 是 ==> \(json)")
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String : Any], let result = YHUserNameCardInfo.deserialize(from: dic) else {
                    let error = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    self.nameCardInfo = YHUserNameCardInfo()
                    callBack(false, error)
                    return
                }
                self.nameCardInfo = result
                callBack(true, nil)
                
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                self.nameCardInfo = YHUserNameCardInfo()
                callBack(false, error)
            }
            
        } failBlock: { error in
            self.nameCardInfo = YHUserNameCardInfo()
            callBack(false, error)
        }
    }
    
    func receiveFriendApply(userId:String, isReceive:Bool, callBack: @escaping (_ success: Bool,_ error: YHErrorModel?)->()) {
        let act = isReceive ? 2 : 1
        let params = ["act": act,
                      "yh_id": userId] as [String : Any]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.People.receiveFriendRequestApi
        let _ = YHNetRequest.postRequest(url: strUrl, params: params) {
            [weak self] json, code in
            //1. json字符串 转 对象
            guard self != nil else { return }
            printLog(json)
            
            if json.code == 200 {
                callBack(true, nil)
            }  else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBack(false, error)
            }
        } failBlock: { err in
            callBack(false, err)
        }
    }
    
    func requestUserAuthorization(callBackBlock:@escaping (_ success: Bool, _ error: YHErrorModel?)->()) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.People.userAuthorization
        let _ = YHNetRequest.getRequest(url: strUrl) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                guard let dic = json.data?.peel as?  [String : Any], let result = YHMainUserInformationSetModel.deserialize(from: dic) else {
                    callBackBlock(false,nil)
                    return
                }
                self.setModel = result
                callBackBlock(true, nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
}
