//
//  YHInvitationNumberItemView.swift
//  galaxy
//
//  Created by EDY on 2024/7/18.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHInvitationNumberItemView: UIView {
    var leftImageView: UIImageView!
    var rightImageView: UIImageView!
    var titleLabel: UILabel!
    var bottomLabel: UILabel!
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setUpView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setUpView() {
        leftImageView = {
            let view = UIImageView()
            view.image = UIImage(named: "invitation_with_gifts_number_left")
            return view
        }()
        addSubview(leftImageView)
        leftImageView.snp.makeConstraints { make in
            make.left.equalToSuperview()
            make.width.height.equalTo(19)
            make.top.equalTo(24)
        }
        
        rightImageView = {
            let view = UIImageView()
            view.image = UIImage(named: "invitation_with_gifts_number_right")
            return view
        }()
        addSubview(rightImageView)
        rightImageView.snp.makeConstraints { make in
            make.right.equalToSuperview()
            make.width.height.equalTo(19)
            make.top.equalTo(24)
        }
        
        titleLabel = {
            let view = UILabel()
            view.text = "38"
            view.font = UIFont.PFSC_M(ofSize: 24)
            view.textColor = UIColor.mainTextColor
            view.textAlignment = .center
            return view
        }()
        addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.top.equalTo(15)
            make.left.right.equalToSuperview()
            make.height.equalTo(33)
        }
        
        bottomLabel = {
            let view = UILabel()
            view.text = "已注册"
            view.font = UIFont.PFSC_M(ofSize: 12)
            view.textColor = UIColor.yhGreyColor
            view.textAlignment = .center
            return view
        }()
        addSubview(bottomLabel)
        bottomLabel.snp.makeConstraints { make in
            make.top.equalTo(47)
            make.left.right.equalToSuperview()
            make.height.equalTo(17)
        }
        
    }
    
}

class YHInvitationPeopleItemView: UIView {
    var titleLabel: UILabel!
    var bgImageView: UIImageView!
    override init(frame: CGRect) {
        super.init(frame: frame)
        setUpView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setUpView() {
        self.backgroundColor = UIColor(hex: 0xebf4fe)
        titleLabel = {
            let view = UILabel()
            view.text = "12"
            view.font = UIFont.PFSC_M(ofSize: 12)
            view.textColor = UIColor.mainTextColor70
            view.textAlignment = .left
            return view
        }()
        addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.top.equalTo(10)
            make.left.equalTo(10)
            make.height.equalTo(17)
            make.right.equalToSuperview()
        }
        
        bgImageView = {
            let view = UIImageView()
            view.isHidden = true
            view.isUserInteractionEnabled = true
            view.image = UIImage(named: "invitation_with_gifts_people_true")
            return view
        }()
        addSubview(bgImageView)
        bgImageView.snp.makeConstraints { make in
            make.width.height.equalTo(14)
            make.center.equalToSuperview()
        }
    }
    
}

