//
//  YHLifeViewController.swift
//  galaxy
//
//  Created by EDY on 2024/7/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import JXSegmentedView
import ESPullToRefresh

class YHLifeViewController: YHBaseViewController {
    var sectionView: YHLifeSectionView!
    var tableView: UITableView!
    var headView = YHLifeHeadView()
    var viewModel: YHHomePageViewModel = YHHomePageViewModel()
    var selectSubTab: YHHomeLifeCategoryModel? = nil
    var selectSubIndex : Int = -1

    override func viewDidLoad() {
        super.viewDidLoad()
        setupUI()
        loadData()
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
    }
}

extension YHLifeViewController {
    func loadData() {
        let params : [String : Any] = ["pid" : 3]
        self.viewModel.getGoodsCategory(params: params) {
            [weak self] success, error in
            self?.tableView.es.stopPullToRefresh()
            guard let self = self else { return }
            let items = self.viewModel.categoryArr.map { $0?.name }
            let result = items.compactMap { $0 }
            self.sectionView.items = result
            if selectSubIndex == -1 {
                selectSubIndex = 0
                self.selectSubTab = self.viewModel.categoryArr.first ?? YHHomeLifeCategoryModel()
            } else {
                
                if self.viewModel.categoryArr.count > selectSubIndex {
                    self.selectSubTab = self.viewModel.categoryArr[selectSubIndex]
                } else {
                    selectSubIndex = 0
                    self.selectSubTab = self.viewModel.categoryArr.first ?? YHHomeLifeCategoryModel()
                }
            }
            
            getDetailImages()
        }
    }
    
    func getDetailImages() {
        if let selectItem = self.selectSubTab  {
            let params:[String: Any] = ["categoryId": "3",
                                        "levelId": selectItem.id]
            self.viewModel.getGoodsCategoryDetail(params: params) {
                [weak self] success, error in
                guard let self = self else { return }
                guard let url = URL(string: selectItem.image) else { return }
                self.headView.imageView.kf.setImage(with: url)
                if self.viewModel.detailModel.products.count == 0 {
                    let label = UILabel(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: self.view.height - 44 - KScreenWidth - 16))
                    label.text = "商品未上架，好货不怕晚，敬请期待！"
                    label.textColor = UIColor.mainTextColor30
                    label.font = UIFont.PFSC_R(ofSize: 14)
                    label.textAlignment = .center
                    self.tableView.tableFooterView = label
                } else {
                    self.tableView.tableFooterView = UIView()
                }
                self.tableView.reloadData()
            }
        }
    }
    
    func setupUI() {
        gk_navBarAlpha = 0
        gk_navigationBar.isHidden = true
        view.backgroundColor = .white
        sectionView = {
            let view = YHLifeSectionView()
            view.block = {[weak self] itemIndex in
                guard let self = self else { return }
                selectSubIndex = itemIndex
                self.selectSubTab = self.viewModel.categoryArr[itemIndex]
                self.getDetailImages()
            }
            return view
        }()
        view.addSubview(sectionView)
        sectionView.snp.makeConstraints { make in
            make.top.left.right.equalToSuperview()
            make.height.equalTo(44)
        }
        headView.frame = CGRect(x: 0, y: 0, width: KScreenWidth, height: KScreenWidth + 28)
        tableView = {
            let tableView = UITableView(frame: .zero, style: .grouped)
            tableView.contentInsetAdjustmentBehavior = .never
            tableView.backgroundColor = .clear
            tableView.separatorStyle = .none
            tableView.showsHorizontalScrollIndicator = false
            tableView.showsVerticalScrollIndicator = false
            tableView.dataSource = self
            tableView.delegate = self
            tableView.tableHeaderView = headView
            tableView.tableFooterView = UIView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: 0.01))
            tableView.register(cellWithClass: YHLifeItemTableViewCell.self)
            return tableView
        }()
        view.addSubview(tableView)
        tableView.snp.makeConstraints { make in
            make.bottom.left.right.equalToSuperview()
            make.top.equalTo(44)
        }
        
        tableView.es.addYHPullToRefresh {
            self.loadData()
        }
    }
}

extension YHLifeViewController: UITableViewDelegate, UITableViewDataSource {
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return self.viewModel.detailModel.products.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withClass: YHLifeItemTableViewCell.self)
        cell.dataSource = self.viewModel.detailModel.products[indexPath.row]
        return cell
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        return 124
    }
    
    func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        return 0.01
    }

    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        return UIView()
    }

    func tableView(_ tableView: UITableView, heightForFooterInSection section: Int) -> CGFloat {
        return 0.01
    }

    func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> UIView? {
        return UIView()
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        let model = self.viewModel.detailModel.products[indexPath.row]
        
        let vc = YHLifeDetailViewController()
        vc.tabId =  self.selectSubTab?.id ?? ""
        vc.productModel = model
        vc.codeUrl = self.viewModel.detailModel.imageURLDefault
        vc.downloadUrl = self.viewModel.detailModel.imageURLDefaultDownload
        self.navigationController?.pushViewController(vc)
        
//        let vc = YHH5WebViewVC()
//        
//        // TODO: - 谢
//        vc.url = YHBaseUrlManager.shared.curH5URL() + "superAppBridge.html#/commodity_info?categoryId=2&levelId=5&productId=30&from=wxApp"
//        vc.isWithBottomViewFlag = true
//        vc.isShareToMiniProgramFlag = true
//                vc.shareMiniPath = "/pages/commodityInfo/commodityInfo?categoryId=3&levelId=\(selectSubTab?.id ?? "")&productId=\(model.id)&from=wxApp"

//        
//        self.navigationController?.pushViewController(vc)
    }
}

extension YHLifeViewController: JXSegmentedListContainerViewListDelegate {
    func listView() -> UIView {
        return view
    }
}
