//
//  YHHomeSearchView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/4/7.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
class YHHomeSearchView: UIView {
    static let viewH : CGFloat = 36.0
    lazy var placeHolderLabel: UILabel = {
        let lable = UILabel()
        lable.text = "香港身份"
        lable.font = UIFont.PFSC_R(ofSize: 13)
        lable.textColor = UIColor.yhGreyColor
        return lable
    }()
    
    var placeHolder: String = ""  {
        didSet {
            self.placeHolderLabel.text = placeHolder
        }
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        initView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
}

private extension YHHomeSearchView {
    func initView() {
        backgroundColor = UIColor(hex: 0xF4F6FA, alpha: 1.0)
        
        let imageV : UIImageView = UIImageView()
        imageV.contentMode = .scaleAspectFill
        imageV.image = UIImage(named: "home_search_icon")
        addSubview(imageV)
        imageV.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.left.equalTo(12)
            make.width.height.equalTo(16)
        }
        
        addSubview(placeHolderLabel)
        placeHolderLabel.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.left.equalTo(imageV.snp.right).offset(8)
            make.height.equalTo(18)
            make.right.equalToSuperview().offset(-12)
        }
    }
}
