//
//  YHAdopterOtherViewController.swift
//  galaxy
//
//  Created by EDY on 2024/8/21.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHAdopterOtherViewController: YHBaseViewController {
    var tableView: UITableView!
    var nextButton: UIButton!
    var clickIndex = -1
    var data: [YHItemModel] = []
    var viewModel = YHYHAdopterTravelViewModel()
    var model: YHAdopterDependentDataDocModel = YHAdopterDependentDataDocModel()
    var urls : [String] = []
    
    override func viewDidLoad() {
        super.viewDidLoad()
        gk_navTitle = "上传其他相关证件"
        gk_navBackgroundColor = .white
        gk_navBarAlpha = 1
        urls = model.url
        setView()
        getData()
    }
    
    func getData() {
        viewModel.mainModel = model
        tableView.reloadData()
    }
    
    func setView() {
        view.backgroundColor = .white
        tableView = {
            let tableView = UITableView(frame:.zero, style:.plain)
            tableView.contentInsetAdjustmentBehavior = .never
            tableView.backgroundColor = .white
            tableView.separatorStyle = .none
            tableView.delegate = self
            tableView.dataSource = self
            tableView.register(cellWithClass: YHAdopterExampleTableViewCell.self)
            tableView.register(cellWithClass: YHAdopterOtherCardTableViewCell.self)
            tableView.register(cellWithClass: YHAdopterCardExplainTableViewCell.self)
            tableView.register(cellWithClass: YHAdopterIncomeFileCountTableViewCell.self)
            let view = UIView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: 20))
            tableView.tableFooterView = view
            return tableView
        }()
        view.addSubview(tableView)
        tableView.snp.makeConstraints { make in
            make.top.equalTo(k_Height_NavigationtBarAndStatuBar + 8)
            make.bottom.left.right.equalTo(view)
        }
    
        nextButton = {
            let button = UIButton(type: .custom)
            button.backgroundColor =  UIColor.brandMainColor
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 16)
            button.contentHorizontalAlignment = .center
            button.setTitle("确认上传", for: .normal)
            button.setTitleColor( UIColor(hex:0xffffff), for: .normal)
            button.layer.cornerRadius = kCornerRadius3
            button.addTarget(self, action: #selector(nextStep), for: .touchUpInside)
            return button
        }()
        view.addSubview(nextButton)
        nextButton.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.bottom.equalTo(-8 - k_Height_safeAreaInsetsBottom())
            make.height.equalTo(48)
        }
        if model.status == 1 || model.status == 3 {
            nextButton.isHidden = true
        } else {
            tableView.snp.remakeConstraints { make in
                make.top.equalTo(k_Height_NavigationtBarAndStatuBar + 8)
                make.left.right.equalTo(view)
                make.bottom.equalTo(-56 - k_Height_safeAreaInsetsBottom())
            }
        }
    }
    
    @objc func nextStep() {
        if urls.count == 0 {
            YHHUD.flash(message: "您还有信息未填写")
            return
        }
        for item in urls {
            if item.count == 0 {
                self.getData()
                YHHUD.flash(message: "请上传文件")
                return
            }
        }
        viewModel.postdependentsUpload(urls: urls) {[weak self] success, error in
            guard let self = self else { return }
            self.navigationController?.popViewController(animated: true)
        }
    }
    
}

extension YHAdopterOtherViewController: UITableViewDelegate, UITableViewDataSource {
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return 4
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        if indexPath.row == 0 {
            let cell = tableView.dequeueReusableCell(withClass: YHAdopterExampleTableViewCell.self)
            cell.titleLabel.text = "其他相关证件说明"
            cell.templateView.titleLabel.text = "查看其他相关证件说明"
            cell.exampleBlock = {[weak self] in
                let view = YHAdopterCardExampleView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: KScreenHeight))
                view.type = .other
                let window = UIApplication.shared.yhKeyWindow()
                window?.addSubview(view)
            }
            return cell
        }
        if indexPath.row == 1 {
            let cell = tableView.dequeueReusableCell(withClass: YHAdopterCardExplainTableViewCell.self)
            cell.titleLabel.text = "其他相关证件"
            cell.alertLabel.text = "请致电客服咨询后上传相关证件"
            cell.docDataSource = model
            return cell
        }
        if indexPath.row == 2 {
            let cell = tableView.dequeueReusableCell(withClass: YHAdopterOtherCardTableViewCell.self)
            cell.state = model.status
            cell.dataSource = urls
            cell.urlBlock = { [weak self] url, index in
                guard let self = self else { return }
                self.urls.append(url)
                self.tableView.reloadData()
            }
            cell.deleteBlock = { [weak self] url, index in
                guard let self = self else { return }
                for (index, value) in urls.enumerated() {
                    if value == url {
                        self.urls.remove(at: index)
                        self.tableView.reloadData()
                    }
                }
            }
            return cell
        }
        if indexPath.row == 3 {
            let cell = tableView.dequeueReusableCell(withClass: YHAdopterIncomeFileCountTableViewCell.self)
            cell.setContentData(self.urls.count)
            if urls.count == 0 {
                cell.isHidden = true
            } else {
                cell.isHidden = false
            }
            return cell
        }
        return UITableViewCell()
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        if indexPath.row == 0 {
            return 118
        }
        if indexPath.row == 1 {
            if model.reject_reason.count != 0 && model.status == 2 {
                return 117
            }
            return 84
        }
        if indexPath.row == 2 {
            var count = urls.count/2
            if count > 4 {
                count = 4
            }
            return CGFloat(173 + count * 143)
        }
        return 45
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
       
    }
    
}
