//
//  YHAdopterDependentModel.swift
//  galaxy
//
//  Created by EDY on 2024/8/23.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SmartCodable

class YHAdopterDependentDataModel: SmartCodable {
    var info : YHAdopterDependentDataInfoModel = YHAdopterDependentDataInfoModel()
    var docList : [YHAdopterDependentDataDocModel] = []
    
    required init() {
    }
}

class YHAdopterDependentDataInfoModel: SmartCodable {
    var id : Int = 0
    var order_sn : String = ""
    var applicant_name : String = ""
    var order_id : Int = 0
    var dep_name : String = ""
    var dep_nationality : Int = 5 //随迁人国籍0大陆1台湾2澳门3海外
    var status : Int = 0 //状态0待完善,1审核中,2已驳回,3已完成
    var sync_status : Int = 0 //状态0待完善, 0未同步 1已同步
    var created_at : String = ""
    var updated_at : String = ""
    var deleted_at : String = ""
    var is_spouse : Int = 0
    var sync_subset_id : Int = 0
    var is_read_agreement : Int = 0
    
    required init() {
    }
}

class YHAdopterDependentDataDocModel: SmartCodable {
    var id : Int = 0
    var dep_name : String = ""
    var dep_type : Int = 0
    var dep_id : Int = 0
    var order_id : Int = 0
    var dep_nationality : Int = 0
    var is_spouse : Int = 0
    var status : Int = 0
    var created_at : String = ""
    var updated_at : String = ""
    var deleted_at : String = ""
    var reject_reason : String = ""
    var require : Int = 0
    var certificates_info : YHAdopterDependentDataDocCertificatesModel = YHAdopterDependentDataDocCertificatesModel()
    var url : [String] = []

    required init() {
    }
}

class YHAdopterDependentDataDocCertificatesModel: SmartCodable {
    var gender : Int = 0 // 1男,2女
    var marital_status : Int = 0 //婚姻状况
    var travel_papers_type : Int = 0 // 旅行证件类型
    var current_place : Int = 0 // 现居地址
    var is_forever_identiry : Int = 0 //是否永久身份:1是,2否
    var is_live_hk : Int = 0 // 是否正在港:1否,2是
    var hk_identity : Int = 0 // 在港身份
    var en_name : String = "" // 英文名称
    var former_name : String = "" // 曾用名
    var before_marriage_name : String = "" // 婚前姓氏
    var birthday : String = "" // 出生日期
    var birth_place : String = "" // 出生地点
    var idcard : String = "" // 身份证号
    var hk_idcard : String = "" //香港身份证号
    var travel_papers_number : String = "" //旅行证件号码
    var sign_address : String = "" // 签发地点
    var sign_date : String = "" //签发时间
    var sign_expire_date : String = "" //签发届满时间
    var live_time : String = "" // 定居居留时间
    var approve_date : String = "" //批准逗留日期
    var will_to_hk_date : String = "" //打算赴港日期
    var will_live_time : String = "" //打算在港逗留时间

    required init() {
    }
}
