//
//  YHAdopterMainModel.swift
//  galaxy
//
//  Created by EDY on 2024/8/22.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SmartCodable

class YHAdopterMainModel: SmartCodable {
    var order_id : Int = 0
    var has_dependent : Int = 2 //是否有受养人
    var spouse_name : String = "" //配偶姓名
    var spouse_used_name : String = "" //配偶曾用名
    var spouse_id : Int = 0
    var has_spouse : Bool = false //是否有配偶
    var has_deposit : Bool = false //是否有旅行证件
    var is_reserved_open: Int = 0 // 0 不显示 1 显示 
    var dependent: [YHAdopterDependentModel] = [] // 受养人数组
    var deposit: YHAdopterDepositModel = YHAdopterDepositModel()
    
    required init() {
    }
}

class YHAdopterDependentModel: SmartCodable {
    var id : Int = 0
    var order_sn : String = ""
    var applicant_name : String = "" //姓名
    var order_id : Int = 0
    var dep_name : String = ""
    var dep_nationality : Int = 0 // 受抚养人国籍0大陆1台湾2澳门3海外
    var status : Int = 0 // 0待完善,1审核中,2已驳回,3已完成
    var sync_status : Int = 0
    var created_at : String = ""
    var updated_at : String = ""
    var deleted_at : String = ""
    var is_spouse : Int = 0 //是否有配偶
    var sync_subset_id : Int = 0

    required init() {
    }
}

class YHAdopterDepositModel: SmartCodable {
    var id : Int = 0
    var order_id : String = ""
    var user_id : Int = 0
    var user_type : String = ""
    var type : Int = 0
    var issue_start :  String = ""
    var issue_end : String = ""
    var img_front : String = ""
    var img_back : String = ""
    var other : String = ""
    var status : Int = 4
    var collect_status : Int = 0
    var checked_user_id : Int = 0
    var checked_at : String = ""
    var commited_at : String = ""
    var remark : String = ""
    var created_at : String = ""
    var updated_at : String = ""
    var deleted_at : String = ""
    var order_sn : String = ""
    var urls: String = ""
    
    required init() {
    }
}

class YHAdopterFileModel: SmartCodable {
    var upload_date : String = ""
    var name : String = ""
    var url: String = ""
    
    required init() {
    }
}
