//
//  YHAdopterCardExampleViewController.swift
//  galaxy
//
//  Created by EDY on 2024/8/21.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHAdopterCardExampleView: UIView {
    var centerView: UIView!
    var titleLabel: UILabel!
    var closeButton: UIButton!
    var tableView: UITableView!
    var lineView: UIView!
    var bottomButton: UIButton!
    var data: [String] = []
    var type: YHAdopterCardType? {
        didSet {
            guard let type = type else { return }
            if type == .china {
                titleLabel.text = "身份证示例模板"
                data = ["service_adopter_example_china"]
                centerView.snp.remakeConstraints { make in
                    make.left.right.bottom.equalToSuperview()
                    make.height.equalTo(691.fix)
                }
            }
            if type == .resident {
                titleLabel.text = "户口信息示例 (仅供参考)"
                data = ["service_adopter_example_resident"]
                centerView.snp.remakeConstraints { make in
                    make.left.right.bottom.equalToSuperview()
                    make.height.equalTo(667.fix)
                }
            }
            if type == .birth {
                titleLabel.text = "出生医学证明示例 (仅供参考)"
                data = ["service_adopter_example_birth"]
                centerView.snp.remakeConstraints { make in
                    make.left.right.bottom.equalToSuperview()
                    make.height.equalTo(453.fix)
                }
            }
            if type == .marry {
                titleLabel.text = "结婚证示例模版"
                data = ["service_adopter_example_marry"]
                centerView.snp.remakeConstraints { make in
                    make.left.right.bottom.equalToSuperview()
                    make.height.equalTo(691.fix)
                }
            }
            if type == .other {
                titleLabel.text = "其他相关证件说明"
                titleLabel.textAlignment = .left
                data = ["service_adopter_example_other1", "service_adopter_example_other2","service_adopter_example_other3","service_adopter_example_other4"]
                centerView.snp.remakeConstraints { make in
                    make.left.right.bottom.equalToSuperview()
                    make.height.equalTo(701.fix)
                }
            }
            
            if type == .travel {
                titleLabel.text = "港澳通行证 (逗留D) 示例 (仅供参考)"
                data = ["service_adopter_example_travel"]
                centerView.snp.remakeConstraints { make in
                    make.left.right.bottom.equalToSuperview()
                    make.height.equalTo(689.fix)
                }
            }
            
            if type == .chinaLife {
                titleLabel.text = "中国居留许可签证 (仅供参考)"
                data = ["service_adopter_example_chinalife"]
                centerView.snp.remakeConstraints { make in
                    make.left.right.bottom.equalToSuperview()
                    make.height.equalTo(422.fix)
                }
            }
            
            if type == .chinaTravel {
                titleLabel.text = "护照示例 (仅供参考)"
                data = ["service_adopter_example_chinatravel"]
                centerView.snp.remakeConstraints { make in
                    make.left.right.bottom.equalToSuperview()
                    make.height.equalTo(659.fix)
                }
            }
        }
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = UIColor(white: 0.5, alpha: 0.1)
        let tap = UITapGestureRecognizer(target: self, action: #selector(handleTap))
        tap.delegate = self
        addGestureRecognizer(tap)
        setView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    static func exampleView(type: YHAdopterCardType?) -> YHAdopterCardExampleView {
        let view = YHAdopterCardExampleView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: KScreenHeight))
        view.type = type
        return view
    }
    
    
    
    func setView() {
        backgroundColor = UIColor(hex: 0x000000, alpha: 0.5)
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.left.right.bottom.equalToSuperview()
            make.height.equalTo(686)
        }
        
        titleLabel = {
            let label = UILabel()
            label.text = "身份证示例模板"
            label.font = UIFont.PFSC_M(ofSize: 17)
            label.textColor = UIColor.mainTextColor
            label.textAlignment = .center
            return label
        }()
        centerView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(21)
            make.right.equalTo(-21)
            make.height.equalTo(21)
            make.top.equalTo(16)
        }
        
        closeButton = {
            let button = UIButton(type: .custom)
            button.setBackgroundImage(UIImage(named: "service_card_close"), for: .normal)
            button.addTarget(self, action: #selector(dismiss), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(closeButton)
        closeButton.snp.makeConstraints { make in
            make.right.equalTo(-21)
            make.width.height.equalTo(24)
            make.top.equalTo(16)
        }
        
        lineView = {
            let view = UIView()
            view.backgroundColor = UIColor.separatorColor
            return view
        }()
        centerView.addSubview(lineView)
        lineView.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(52)
            make.height.equalTo(1)
            make.right.equalTo(-18)
        }
        
        tableView = {
            let tableView = UITableView(frame:.zero, style:.plain)
            tableView.contentInsetAdjustmentBehavior = .never
            tableView.backgroundColor = .white
            tableView.separatorStyle = .none
            tableView.delegate = self
            tableView.dataSource = self
            tableView.register(cellWithClass: YHAdopterCardExampleViewTableViewCell.self)
            return tableView
        }()
        centerView.addSubview(tableView)
        tableView.snp.makeConstraints { make in
            make.top.equalTo(73)
            make.bottom.equalTo(-103)
            make.left.right.equalToSuperview()
        }
        
        bottomButton = {
            let button = UIButton(type: .custom)
            button.backgroundColor =  UIColor(hex:0x4d9ffb)
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 16)
            button.contentHorizontalAlignment = .center
            button.setTitle("知道了", for: .normal)
            button.setTitleColor( UIColor(hex:0xffffff), for: .normal)
            button.layer.cornerRadius = kCornerRadius3
            button.clipsToBounds = true
            button.addTarget(self, action: #selector(dismiss), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(bottomButton)
        bottomButton.snp.makeConstraints { make in
            make.right.equalTo(-21)
            make.left.equalTo(21)
            make.bottom.equalTo(-42)
            make.height.equalTo(48)
        }
        bottomButton.layoutIfNeeded()
        
        bottomButton.addYinHeGradualLayer()
    }
    
    @objc private func handleTap(_ sender: AnyObject?) {
        print("处理点击手势")
        dismiss()
    }
    
    @objc func show() {
        UIApplication.shared.yhKeyWindow()?.addSubview(self)
    }
    
    @objc func dismiss() {
        removeFromSuperview()
    }
}

extension YHAdopterCardExampleView: UIGestureRecognizerDelegate {
    func gestureRecognizer(_ gestureRecognizer:UIGestureRecognizer, shouldReceive touch:UITouch) -> Bool {
        if touch.view == self {
            return true
        }
        return false
    }
}

extension YHAdopterCardExampleView: UITableViewDelegate, UITableViewDataSource {
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return data.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withClass: YHAdopterCardExampleViewTableViewCell.self)
        cell.imageName = data[indexPath.row]
        return cell
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        guard let type = type else { return 0 }
        if type == .china {
            return 507.fix + 20
        }
        if type == .resident {
            return 482.fix + 20
        }
        if type == .birth {
            return 269.fix + 20
        }
        if type == .marry {
            return 968.fix + 20
        }
        if type == .travel {
            return 508.fix + 20
        }
        if type == .chinaLife {
            return 238.fix + 20
        }
        if type == .chinaTravel {
            return 476.fix + 20
        }
        if type == .other {
            if indexPath.row == 0 {
                return 204.fix + 20
            }
            if indexPath.row == 1 {
                return 147.fix + 20
            }
            if indexPath.row == 2 {
                return 91.fix + 20
            }
            if indexPath.row == 3 {
                return 91.fix + 20
            }
        }
        
        return 0
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
       
    }
    
}

class YHAdopterCardExampleViewTableViewCell: UITableViewCell {
    var bgImageView: UIImageView!
    var imageName: String? {
        didSet {
            bgImageView.image = UIImage(named: imageName ?? "")
        }
    }
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        backgroundColor = .clear

        bgImageView = {
            let imageView = UIImageView()
            return imageView
        }()
        contentView.addSubview(bgImageView)
        bgImageView.snp.makeConstraints { make in
            make.left.equalTo(20)
            make.right.bottom.equalTo(-20)
            make.top.equalTo(0)
        }
        
    }

}
