//
//  YHAdopterCardExplainTableViewCell.swift
//  galaxy
//
//  Created by EDY on 2024/8/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHAdopterCardExplainTableViewCell: UITableViewCell {
    var titleLabel: UILabel!
    var subTitleLabel: UILabel!
    var alertLabel: UILabel!
    var failLabel: UILabel!
    var failImageView: UIImageView!
    var docDataSource: YHAdopterDependentDataDocModel? {
        didSet {
            updateDocContent()
        }
    }
    
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        backgroundColor = .clear

        titleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 17)
            label.textColor = UIColor.mainTextColor
            label.text = "中国身份证"
            return label
        }()
        contentView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(34)
            make.height.equalTo(24)
        }
        
        subTitleLabel = {
            let label = UILabel()
            label.text = "已完成"
            label.font = UIFont.PFSC_M(ofSize: 10)
            label.textColor = UIColor(hex: 0x3cc694)
            label.backgroundColor = UIColor(hex: 0xf0fbf7)
            label.textAlignment = .center
            //带上传
//            label.textColor = UIColor.brandMainColor
//            label.backgroundColor = UIColor(hex: 0xf0f4fb)
            //审核中
//            label.textColor = UIColor(hex: 0xff8000)
//            label.backgroundColor = UIColor(hex: 0xfff5eb)
            //已驳回
//            label.textColor = UIColor(hex: 0xf81d22)
//            label.backgroundColor = UIColor(hex: 0xfff2f2)
            return label
        }()
        contentView.addSubview(subTitleLabel)
        subTitleLabel.snp.makeConstraints { make in
            make.left.equalTo(titleLabel.snp.right).offset(4)
            make.width.equalTo(38)
            make.height.equalTo(16)
            make.centerY.equalTo(titleLabel.snp.centerY)
        }
        
        alertLabel = {
            let label = UILabel()
//            label.text = "存款证明有效期为3个月，并且存款金额为每个成员（包括额外新增受养人）最低为12万"
            label.font = UIFont.PFSC_R(ofSize: 14)
            label.textColor = UIColor.mainTextColor50
            label.numberOfLines = 0
            return label
        }()
        contentView.addSubview(alertLabel)
        alertLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(64)
            make.right.equalTo(-18)
        }
        
        failLabel = {
            let label = UILabel()
            label.text = "驳回原因：存款证明钱不够"
            label.font = UIFont.PFSC_R(ofSize: 12)
            label.textColor = UIColor(hex: 0xf81d22)
            return label
        }()
        contentView.addSubview(failLabel)
        failLabel.snp.makeConstraints { make in
            make.left.equalTo(36)
            make.bottom.equalTo(0)
            make.height.equalTo(17)
            make.right.equalToSuperview()
        }
        
        failImageView = {
            let view = UIImageView()
            view.image = UIImage(named: "service_adopter_income_fail_alert")
            return view
        }()
        contentView.addSubview(failImageView)
        failImageView.snp.makeConstraints { make in
            make.left.equalTo(20)
            make.width.height.equalTo(12)
            make.centerY.equalTo(failLabel.snp.centerY)
        }
        
    }
    
    func updateDocContent() {
        guard let data = docDataSource else { return }
        if data.status == 0 {
            subTitleLabel.textColor = UIColor.brandMainColor
            subTitleLabel.backgroundColor = UIColor(hex: 0xf0f4fb)
            subTitleLabel.text = "待上传"
            failImageView.isHidden = true
            failLabel.isHidden = true
        }
        if data.status == 1 {
            subTitleLabel.textColor = UIColor(hex: 0xff8000)
            subTitleLabel.backgroundColor = UIColor(hex: 0xfff5eb)
            subTitleLabel.text = "审核中"
            failImageView.isHidden = true
            failLabel.isHidden = true
        }
        if data.status == 3 {
            subTitleLabel.textColor = UIColor(hex: 0x3cc694)
            subTitleLabel.backgroundColor = UIColor(hex: 0xf0fbf7)
            subTitleLabel.text = "已完成"
            failImageView.isHidden = true
            failLabel.isHidden = true
        }
        if data.status == 2 {
            subTitleLabel.textColor = UIColor(hex: 0xf81d22)
            subTitleLabel.backgroundColor = UIColor(hex: 0xfff2f2)
            subTitleLabel.text = "已驳回"
            failImageView.isHidden = false
            failLabel.isHidden = false
        }
        failLabel.text = data.reject_reason
    }
}
