//
//  YHAdopterIncomeFileCountTableViewCell.swift
//  galaxy
//
//  Created by EDY on 2024/8/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHAdopterIncomeFileCountTableViewCell: UITableViewCell {
    var alertLabel: UILabel!
    
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        backgroundColor = .clear
        
        alertLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_R(ofSize: 12)
            label.textColor = UIColor.mainTextColor50
            label.textAlignment = .center
            label.numberOfLines = 0
            let a: ASAttributedString = .init("已上传 ", .font(UIFont.PFSC_R(ofSize: 12)),.foreground(UIColor.labelTextColor2))
            let b: ASAttributedString = .init(" 0/10", .font(UIFont.PFSC_R(ofSize: 12)),.foreground(UIColor(hex: 0x222222)))
            let c: ASAttributedString = .init(" 张图片或文件", .font(UIFont.PFSC_R(ofSize: 12)),.foreground(UIColor.labelTextColor2))
            label.attributed.text = a + b + c
            return label
        }()
        contentView.addSubview(alertLabel)
        alertLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.bottom.equalTo(0)
            make.right.equalTo(-18)
        }
    }
    
    func setContentData(_ count: Int) {
        let a: ASAttributedString = .init("已上传 ", .font(UIFont.PFSC_R(ofSize: 12)),.foreground(UIColor.labelTextColor2))
        let b: ASAttributedString = .init(" \(count)/10", .font(UIFont.PFSC_R(ofSize: 12)),.foreground(UIColor(hex: 0x222222)))
        let c: ASAttributedString = .init(" 张图片或文件", .font(UIFont.PFSC_R(ofSize: 12)),.foreground(UIColor.labelTextColor2))
        alertLabel.attributed.text = a + b + c
    }
}
