//
//  YHAdopterIncomeFileTableViewCell.swift
//  galaxy
//
//  Created by EDY on 2024/8/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHAdopterIncomeFileTableViewCell: UITableViewCell {

    typealias ExperienceListBlock = (_ model: YHWorkExperienceFileModel, _ type: YHWorkFileClickType) -> ()
    var experienceListBlock: ExperienceListBlock?
    var mainItemView: UIView!
    var dataSource: [YHWorkExperienceFileModel]?{
        didSet {
            updateAllViews()
        }
    }
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        backgroundColor = .clear
        mainItemView = {
            let view = UIView()
            view.backgroundColor = .white
            return view
        }()
        contentView.addSubview(mainItemView)
        mainItemView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.bottom.equalToSuperview()
            make.top.equalTo(16)
        }
    }
    
    func updateAllViews() {
        mainItemView.removeSubviews()
        for i in 0 ..< (dataSource?.count ?? 0) {
            let itemView = YHWorkFileItemView()
            itemView.dataSource = dataSource?[i]
            itemView.block = {[weak self] model, type in
                guard let self = self else { return }
                if let block = self.experienceListBlock {
                    block(model, type)
                }
            }
            mainItemView.addSubview(itemView)
            itemView.snp.makeConstraints { make in
                make.left.right.equalToSuperview()
                make.top.equalTo(55 * i)
                make.height.equalTo(55)
            }
        }
    }
}
