//
//  YHAdopterIncomeTableViewCell.swift
//  galaxy
//
//  Created by EDY on 2024/8/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHAdopterIncomeTableViewCell: UITableViewCell {
    typealias ClicktBlock = (_ model: Int) -> ()
    var clickBlock: ClicktBlock?
    var centerView: UIView!
    var titleLabel: UILabel!
    var alertLabel: UILabel!
    var selectLabel: UILabel!
    var lineView: UIView!
    var moreButton: UIButton!
    var dataSource: YHAdopterDepositModel? {
        didSet {
            updateContent()
        }
    }
    
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        backgroundColor = .clear
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        contentView.addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.equalTo(7)
            make.bottom.equalTo(-7)
        }
        
        titleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 17)
            label.textColor = UIColor.mainTextColor
            label.text = "主申请人资料"
            return label
        }()
        centerView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(23)
            make.height.equalTo(24)
            make.right.equalTo(-18)
        }
        
        alertLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_R(ofSize: 12)
            label.textColor = UIColor.mainTextColor50
            label.numberOfLines = 0
            let a: ASAttributedString = .init("温馨提示：存款证明需主申名下，", .font(UIFont.PFSC_R(ofSize: 13)),.foreground(UIColor.mainTextColor50))
            let b: ASAttributedString = .init("申请前近3个月内开具有效", .font(UIFont.PFSC_R(ofSize: 13)),.foreground(UIColor.brandMainColor))
            let c: ASAttributedString = .init("，总存款金额为所有家庭成员(包括额外新增受养人)的", .font(UIFont.PFSC_R(ofSize: 13)),.foreground(UIColor.mainTextColor50))
            let d: ASAttributedString = .init("个数乘以12万", .font(UIFont.PFSC_R(ofSize: 13)),.foreground(UIColor.brandMainColor))
            let e: ASAttributedString = .init("，如一家三口则需主申直接开具36万", .font(UIFont.PFSC_R(ofSize: 13)),.foreground(UIColor.mainTextColor50))
            label.attributed.text = a + b + c + d + e
            return label
        }()
        centerView.addSubview(alertLabel)
        alertLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(79)
            make.right.equalTo(-18)
        }
        
        lineView = {
            let view = UIView()
            view.backgroundColor = UIColor.separatorColor
            return view
        }()
        centerView.addSubview(lineView)
        lineView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.top.equalTo(63)
            make.height.equalTo(0.5)
        }
        
        selectLabel = {
            let label = UILabel()
            label.text = "上传存款证明"
            label.font = UIFont.PFSC_R(ofSize: 14)
            label.textColor = UIColor.mainTextColor
            return label
        }()
        centerView.addSubview(selectLabel)
        selectLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.bottom.equalTo(-20)
            make.height.equalTo(20)
            make.width.equalTo(110)
        }
        
        moreButton = {
            let button = UIButton(type: .custom)
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 13)
            button.contentHorizontalAlignment = .center
            button.setTitle("待上传", for: .normal)
            button.setImage(UIImage(named: "service_adopter_income_start"), for: .normal)
            button.setTitleColor(UIColor.brandMainColor, for: .normal)
            button.addTarget(self, action: #selector(more), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(moreButton)
        moreButton.snp.makeConstraints { make in
            make.centerY.equalTo(selectLabel.snp.centerY)
            make.right.equalTo(-20)
            make.height.equalTo(20)
            make.width.equalTo(69)
        }

        moreButton.iconInRight(with: 1)
    }
    
    @objc func more() {
        if let block = clickBlock {
            block(0)
        }
    }
    
    func updateContent() {
        guard let data = dataSource else { return }
        if data.status == 4 {
            moreButton.setTitle("待上传", for: .normal)
            moreButton.setImage(UIImage(named: "service_adopter_income_start"), for: .normal)
            moreButton.setTitleColor(UIColor.brandMainColor, for: .normal)
        }
        if data.status == 0 {
            moreButton.setTitle("审核中", for: .normal)
            moreButton.setImage(UIImage(named: "service_adopter_income_wait"), for: .normal)
            moreButton.setTitleColor(UIColor(hex: 0xff8000), for: .normal)
        }
        if data.status == 1 {
            moreButton.setTitle("已完成", for: .normal)
            moreButton.setImage(UIImage(named: "service_adopter_income_success"), for: .normal)
            moreButton.setTitleColor(UIColor(hex: 0x3cc694), for: .normal)
        }
        if data.status == 2 {
            moreButton.setTitle("已驳回", for: .normal)
            moreButton.setImage(UIImage(named: "service_adopter_income_fail"), for: .normal)
            moreButton.setTitleColor(UIColor.failColor, for: .normal)
        }
    }
}
