//
//  YHAdopterMainTableViewCell.swift
//  galaxy
//
//  Created by EDY on 2024/8/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHAdopterMainTableViewCell: UITableViewCell {
    typealias ClicktBlock = (_ model: Int) -> ()
    var clickBlock: ClicktBlock?
    var centerView: UIView!
    var titleLabel: UILabel!
    var subTitleLabel: UILabel!
    var alertLabel: UILabel!   
    var selectLabel: UILabel!
    var lineView: UIView!
    var cannalButton: UIButton!
    var moreButton: UIButton!

    var clickIndex: Int? {
        didSet {
            if clickIndex == 0 {
                moreButton.isSelected = false
                cannalButton.isSelected = true
                moreButton.layer.borderWidth = 0
                cannalButton.layer.borderWidth = 1
            }
            if clickIndex == 1 {
                moreButton.isSelected = true
                cannalButton.isSelected = false
                moreButton.layer.borderWidth = 1
                cannalButton.layer.borderWidth = 0
            }
        }
    }
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        backgroundColor = .clear
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        contentView.addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.equalTo(7)
            make.bottom.equalTo(-7)
        }
        
        titleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 17)
            label.textColor = UIColor.mainTextColor
            let str = "* " + "受养人信息核实"
            let attributes: [NSAttributedString.Key: Any] = [
                .font: UIFont.PFSC_M(ofSize: 17),
                .foregroundColor: UIColor.mainTextColor
            ]
            let questionAttrStr = NSMutableAttributedString(string: str, attributes: attributes)
            let starRange = NSRange(location: 0, length: 2)
            questionAttrStr.addAttribute(NSAttributedString.Key.foregroundColor, value: UIColor.failColor, range: starRange)
            label.attributedText = questionAttrStr
            return label
        }()
        centerView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(16)
//            make.height.equalTo(24)
            make.right.equalTo(-18)
        }
        
        subTitleLabel = {
            let label = UILabel()
            label.text = "(受养人：与主申共同获得香港身份的配偶或子女)"
            label.font = UIFont.PFSC_R(ofSize: 12)
            label.textColor = UIColor.mainTextColor50
            return label
        }()
        centerView.addSubview(subTitleLabel)
        subTitleLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(42)
            make.height.equalTo(17)
            make.right.equalTo(-18)
        }
        
        alertLabel = {
            let label = UILabel()
            label.text = "(受养人：与主申共同获得香港身份的配偶或子女)"
            label.font = UIFont.PFSC_R(ofSize: 12)
            label.textColor = UIColor.mainTextColor50
            label.numberOfLines = 0
            let a: ASAttributedString = .init("备注：如最初递交申请文书时，已全部递交受养人信息与资料，此时", .font(UIFont.PFSC_R(ofSize: 13)),.foreground(UIColor.mainTextColor50))
            let b: ASAttributedString = .init("无需再新增受养人信息，则选项选择“否”", .font(UIFont.PFSC_R(ofSize: 13)),.foreground(UIColor.brandMainColor))
            label.attributed.text = a + b
            return label
        }()
        centerView.addSubview(alertLabel)
        alertLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(97)
            make.right.equalTo(-18)
        }
        
        lineView = {
            let view = UIView()
            view.backgroundColor = UIColor.separatorColor
            return view
        }()
        centerView.addSubview(lineView)
        lineView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.top.equalTo(71)
            make.height.equalTo(0.5)
        }
        
        selectLabel = {
            let label = UILabel()
            label.text = "是否新增受养人"
            label.font = UIFont.PFSC_R(ofSize: 14)
            label.textColor = UIColor.mainTextColor
            return label
        }()
        centerView.addSubview(selectLabel)
        selectLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.bottom.equalTo(-22)
            make.height.equalTo(20)
            make.width.equalTo(110)
        }
        
        cannalButton = {
            let button = UIButton(type: .custom)
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 13)
            button.contentHorizontalAlignment = .center
            button.setTitle("否", for: .normal)
            button.setTitleColor(UIColor.mainTextColor, for: .normal)
            button.setTitleColor(UIColor.brandMainColor, for: .selected)
            button.addTarget(self, action: #selector(cannal), for: .touchUpInside)
            button.setBackgroundColor(color: UIColor.contentBkgColor, forState: .normal)
            button.setBackgroundColor(color: UIColor(hex: 0xf0f4fb), forState: .selected)
            button.layer.borderColor = UIColor.brandMainColor.cgColor
            button.layer.borderWidth = 0
            button.layer.cornerRadius = 16
            return button
        }()
        centerView.addSubview(cannalButton)
        cannalButton.snp.makeConstraints { make in
            make.bottom.equalTo(-16)
            make.right.equalTo(-18)
            make.height.equalTo(32)
            make.width.equalTo(69)
        }
        
        moreButton = {
            let button = UIButton(type: .custom)
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 13)
            button.contentHorizontalAlignment = .center
            button.setTitle("是", for: .normal)
            button.setTitleColor(UIColor.mainTextColor, for: .normal)
            button.setTitleColor(UIColor.brandMainColor, for: .selected)
            button.setBackgroundColor(color: UIColor.contentBkgColor, forState: .normal)
            button.setBackgroundColor(color: UIColor(hex: 0xf0f4fb), forState: .selected)
            button.layer.cornerRadius = 16
            button.layer.borderColor = UIColor.brandMainColor.cgColor
            button.layer.borderWidth = 0
            button.addTarget(self, action: #selector(more), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(moreButton)
        moreButton.snp.makeConstraints { make in
            make.bottom.equalTo(-16)
            make.right.equalTo(-95)
            make.height.equalTo(32)
            make.width.equalTo(69)
        }

    }
    
    
    @objc func cannal() {
        moreButton.isSelected = false
        cannalButton.isSelected = true
        moreButton.layer.borderWidth = 0
        cannalButton.layer.borderWidth = 1
        if let block = clickBlock {
            block(0)
        }
    }
    
    @objc func more() {
        moreButton.isSelected = true
        cannalButton.isSelected = false
        moreButton.layer.borderWidth = 1
        cannalButton.layer.borderWidth = 0
        if let block = clickBlock {
            block(1)
        }
    }
}
