//
//  YHAdopterOtherCardTableViewCell.swift
//  galaxy
//
//  Created by EDY on 2024/8/28.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHAdopterOtherCardTableViewCell: UITableViewCell {
    typealias UrlBlock = (_ url: String, _ index: Int) -> ()
    var urlBlock: UrlBlock?
    var deleteBlock: UrlBlock?

    lazy var collectView = {
        // 设置布局方向
        let flowLayout = YHHomeCollectionLayout()
        flowLayout.minimumInteritemSpacing = 7.0
        flowLayout.minimumColumnSpacing = 7.0
        flowLayout.sectionInset = UIEdgeInsets(top: 16, left: 20, bottom: 0, right: 20)
        
        let collectinoView = UICollectionView(frame: .zero, collectionViewLayout: flowLayout)
        collectinoView.backgroundColor = .white
        collectinoView.register(YHAdopterOtherCardCollectionViewCell.self, forCellWithReuseIdentifier:YHAdopterOtherCardCollectionViewCell.cellReuseIdentifier)
        collectinoView.delegate = self
        collectinoView.dataSource = self
        collectinoView.translatesAutoresizingMaskIntoConstraints = false
        collectinoView.alwaysBounceVertical = true
        return collectinoView
    }()
    var state: Int = 0
    var dataSource: [String] = [] {
        didSet {
            if state == 1 || state == 3 {
                
            } else {
                self.dataSource.append("")
            }
            self.collectView.reloadData()
        }
    }
    
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        backgroundColor = .clear
        
        let lineView = UIView()
        lineView.backgroundColor = UIColor.separatorColor
        contentView.addSubview(lineView)
        lineView.snp.makeConstraints { make in
            make.left.equalTo(20)
            make.right.equalTo(-20)
            make.height.equalTo(0.5)
            make.top.equalTo(16)
        }
    
        contentView.addSubview(collectView)
        collectView.snp.makeConstraints { make in
            make.left.right.bottom.equalToSuperview()
            make.top.equalTo(17)
        }
    }
}

extension YHAdopterOtherCardTableViewCell: UICollectionViewDelegate, UICollectionViewDataSource {
    
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        if self.dataSource.count < 10 {
            return self.dataSource.count
        }
        return 10
    }
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        let cell = collectionView.dequeueReusableCell(withReuseIdentifier: YHAdopterOtherCardCollectionViewCell.cellReuseIdentifier, for: indexPath) as! YHAdopterOtherCardCollectionViewCell
        cell.url = self.dataSource[indexPath.row]
        cell.index = indexPath.row + 1
        cell.state = state
        cell.urlBlock = { [weak self] url, index in
            guard let self = self else { return }
            if let block = self.urlBlock {
                block(url, index)
            }
        }
        cell.deleteBlock = { [weak self] url, index in
            guard let self = self else { return }
            if let block = self.deleteBlock {
                block(url, index)
            }
        }
        return cell
    }
    
    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
    
    }

}

extension YHAdopterOtherCardTableViewCell : CollectionViewWaterfallLayoutDelegate {
    func collectionView(_ collectionView: UICollectionView, layout: UICollectionViewLayout, sizeForItemAtIndexPath indexPath: NSIndexPath) -> CGSize {
        return CGSize(width: 168.fix, height: 133)
    }
}

class YHAdopterOtherCardCollectionViewCell: UICollectionViewCell {
    static let cellReuseIdentifier = "YHAdopterOtherCardCollectionViewCell"
    typealias UrlBlock = (_ url: String, _ index: Int) -> ()
    var urlBlock: UrlBlock?
    var deleteBlock: UrlBlock?
    
    var imagePickView: YHCardUploadView!
    
    var url: String? {
        didSet {
            updataSubViews()
        }
    }
    var state: Int = 0 {
        didSet {
            if self.state == 1 || self.state == 3 {
                imagePickView.state = true
            }
        }
    }
    
    var index: Int = 0 {
        didSet {
            imagePickView.defaultName = "相关证件\(index)"
        }
    }
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }
    
   
}

extension YHAdopterOtherCardCollectionViewCell {
    
    private func setupUI() {
        imagePickView = {
            let view = YHCardUploadView()
            view.urlBlock = { [weak self] url, index in
                guard let self = self else { return }
                if let block = self.urlBlock {
                    block(url, index)
                }
            }
            view.deleteBlock = { [weak self] url, index in
                guard let self = self else { return }
                if let block = self.deleteBlock {
                    block(url, index)
                }
            }
            return view
        }()
        contentView.addSubview(imagePickView)
        imagePickView.snp.makeConstraints { make in
            make.left.right.top.bottom.equalToSuperview()
        }
    }
    
    func updataSubViews() {
        imagePickView.url = url
    }
}
