//
//  YHAdopterStepTableViewCell.swift
//  galaxy
//
//  Created by EDY on 2024/8/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHAdopterStepTableViewCell: UITableViewCell {

    typealias ClicktBlock = (_ model: Int) -> ()
    var clickBlock: ClicktBlock?
    var centerView: UIView!
    var titleLabel: UILabel!
    var stepView: YHStepView!

    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        backgroundColor = .clear
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        contentView.addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.equalTo(7)
            make.bottom.equalTo(-7)
        }
        
        stepView = {
            let step = YHStepView()
            step.viewWidth = KScreenWidth - 32
            step.dataSource = ["收集资料", "递交申请", "跟踪申请结果"]
            step.block = { [weak self] (index) in
                guard let self = self else { return }
            }
            return step
        }()
        centerView.addSubview(stepView)
        stepView.snp.makeConstraints { make in
            make.bottom.left.right.equalToSuperview()
            make.height.equalTo(104)
        }

        titleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_R(ofSize: 12)
            label.textColor = UIColor.mainTextColor50
            label.text = "受养人申请身份流程"
            return label
        }()
        centerView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(16)
            make.height.equalTo(16)
            make.right.equalTo(-18)
        }
    }
    
}
