//
//  YHCardUploadView.swift
//  galaxy
//
//  Created by EDY on 2024/8/28.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHCardUploadView: UIView {
    
    typealias UrlBlock = (_ url: String, _ index: Int) -> ()
    var urlBlock: UrlBlock?
    var deleteBlock: UrlBlock?
    var frontLabel: UILabel!
    var frontImageButton: YHCardButton!
    var frontDeleteButton: UIButton!
    var viewModel: YHBaseViewModel = YHBaseViewModel()
    var firstUrl: String = ""
    var defaultImageName: String = "service_adopter_card_other_front" {
        didSet {
            frontImageButton.setBackgroundImage(UIImage(named: defaultImageName), for: .normal)
        }
    }
    var defaultName: String = "相关证件1" {
        didSet {
            frontLabel.text = defaultName
        }
    }
    var url: String? {
        didSet {
            guard let firstUrl = url, firstUrl.count != 0 else {
                self.firstUrl = ""
                frontDeleteButton.isHidden = true
                frontImageButton.setBackgroundImage(UIImage(named: defaultImageName), for: .normal)
                frontImageButton.setContent("card_upload", "点击上传")
                return
            }
            self.firstUrl = firstUrl
            self.viewModel.getPublicImageUrl(firstUrl) {[weak self] success, error in
                guard let self = self else { return }
                guard let url = success else { return }
                self.frontImageButton.kf.setBackgroundImage(with: URL(string: url), for: .normal, completionHandler:  { _ in
                    self.frontDeleteButton.isHidden = false
                    if self.state ?? false {
                        self.frontDeleteButton.isHidden = true
                    }
                })
                self.frontImageButton.setContent("", "")
            }
        }
    }

    var state: Bool? {
        didSet {
            if state ?? false {
                frontDeleteButton.isHidden = true
            }
        }
    }
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    func setupUI() {
        backgroundColor = .clear
        
        frontLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_R(ofSize: 12)
            label.textColor = UIColor.mainTextColor50
            label.text = defaultName
            label.textAlignment = .center
            return label
        }()
        addSubview(frontLabel)
        frontLabel.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.top.equalTo(0)
            make.height.equalTo(22)
        }
        
        frontImageButton = {
            let button = YHCardButton()
            button.setContent("card_upload", "点击上传")
            button.setBackgroundImage(UIImage(named: "service_adopter_card_other_front"), for: .normal)
            button.addTarget(self, action: #selector(frontImageClick), for: .touchUpInside)
            button.layer.cornerRadius = 4
            button.clipsToBounds = true
            return button
        }()
        addSubview(frontImageButton)
        frontImageButton.snp.makeConstraints { make in
            make.left.bottom.equalToSuperview()
            make.height.equalTo(99)
            make.right.equalTo(-8)
        }
        
        frontDeleteButton = {
            let button = UIButton(type: .custom)
            button.setBackgroundImage(UIImage(named: "service_card_delete"), for: .normal)
            button.addTarget(self, action: #selector(frontDeleteClick), for: .touchUpInside)
            button.isHidden = true
            return button
        }()
        addSubview(frontDeleteButton)
        frontDeleteButton.snp.makeConstraints { make in
            make.centerX.equalTo(frontImageButton.snp.right)
            make.centerY.equalTo(frontImageButton.snp.top)
            make.height.equalTo(21)
            make.width.equalTo(21)
        }
    }
    
    @objc func frontImageClick() {
        if firstUrl.count != 0 {
            let vc = YHImageViewController()
            vc.imgString = firstUrl
            UIViewController.current?.navigationController?.pushViewController(vc)
            return
        }
        if state ?? false {
            return
        }
        YHImagePickerView.show() {[weak self] image in
            guard let self = self else { return }
            self.frontImageButton.setContent("card_loading", "上传中")
            self.frontImageButton.startRotationAnimation()
            self.viewModel.uploadImage(image) {[weak self] success, error in
                guard let self = self else { return }
                self.frontImageButton.stopRotationAnimation()
                self.frontImageButton.setContent("", "")
                guard let url = success else { return }
                self.firstUrl = url
                self.frontImageButton.setBackgroundImage(image, for: .normal)
                self.frontDeleteButton.isHidden = false
                if let block = self.urlBlock {
                    block(url, 0)
                }
            }
        }
    }
    
    @objc func frontDeleteClick() {
        firstUrl = ""
        frontDeleteButton.isHidden = true
        frontImageButton.setBackgroundImage(UIImage(named: defaultImageName), for: .normal)
        frontImageButton.setContent("card_upload", "点击上传")
        if let block = deleteBlock {
            block(url ?? "", 0)
        }
    }
    
}

extension YHCardUploadView {
    
    func remakeUploadViewConstraints() {
        
        frontLabel.snp.remakeConstraints { make in
            make.left.right.equalToSuperview()
            make.top.equalTo(0)
            make.height.equalTo(20)
        }
        
        frontImageButton.snp.remakeConstraints { make in
            make.top.equalTo(frontLabel.snp.bottom).offset(12.0)
            make.left.bottom.equalToSuperview()
            make.height.equalTo(90)
            make.right.equalTo(-10)
        }
        
        frontDeleteButton.snp.remakeConstraints { make in
            make.centerX.equalTo(frontImageButton.snp.right)
            make.centerY.equalTo(frontImageButton.snp.top)
            make.height.equalTo(21)
            make.width.equalTo(21)
        }
        
        self.setNeedsLayout()
        self.layoutIfNeeded()
    }
}
