//
//  YHNoAdopterAlertView.swift
//  galaxy
//
//  Created by EDY on 2024/8/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHNoAdopterAlertView: UIView, UIGestureRecognizerDelegate {
    var centerView: UIView!
    var topImageView: UIImageView!
    var bgImageView: UIImageView!
    var titleLabel: UILabel!
    var nextButton: UIButton!
    var alertLabel: UILabel!

    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = UIColor(white: 0.5, alpha: 0.1)
        setView()
        let tap = UITapGestureRecognizer(target: self, action: #selector(handleTap))
        tap.delegate = self
        addGestureRecognizer(tap)
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setView() {
        backgroundColor = UIColor(hex: 0x000000, alpha: 0.5)
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            return view
        }()
        addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.center.equalToSuperview()
            make.height.equalTo(299)
            make.width.equalTo(307)
        }
        
        topImageView = {
            let imageView = UIImageView()
            imageView.image = UIImage(named: "service_adopter_no_alert")
            return imageView
        }()
        centerView.addSubview(topImageView)
        topImageView.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.height.width.equalTo(53)
            make.top.equalTo(30)
        }
        
        titleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_R(ofSize: 17)
            label.textColor = UIColor.mainTextColor
            label.text = "风险预警"
            label.textAlignment = .center
            return label
        }()
        centerView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.height.equalTo(24)
            make.top.equalTo(99)
        }
        
        alertLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_R(ofSize: 12)
            label.textColor = UIColor.mainTextColor50
            label.numberOfLines = 0
            let a: ASAttributedString = .init("如若在主申请者激活电子签证后才新增受养人，", .font(UIFont.PFSC_R(ofSize: 13)),.foreground(UIColor.mainTextColor50))
            let b: ASAttributedString = .init("港府将会要求您提供香港的住址证明，可能会导致您产生租房的新增费用", .font(UIFont.PFSC_R(ofSize: 13)),.foreground(UIColor.brandMainColor))
            let c: ASAttributedString = .init("，请您务必知悉！", .font(UIFont.PFSC_R(ofSize: 13)),.foreground(UIColor.mainTextColor50))
            label.attributed.text = a + b + c
            return label
        }()
        centerView.addSubview(alertLabel)
        alertLabel.snp.makeConstraints { make in
            make.left.equalTo(21)
            make.top.equalTo(131)
            make.right.equalTo(-21)
        }
        
        nextButton = {
            let button = UIButton(type: .custom)
            button.backgroundColor =  UIColor.brandMainColor
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 16)
            button.contentHorizontalAlignment = .center
            button.setTitle("我已知悉，确认", for: .normal)
            button.setTitleColor( UIColor(hex:0xffffff), for: .normal)
            button.layer.cornerRadius = kCornerRadius3
            button.addTarget(self, action: #selector(nextStep), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(nextButton)
        nextButton.snp.makeConstraints { make in
            make.left.equalTo(21)
            make.right.equalTo(-21)
            make.bottom.equalTo(-21)
            make.height.equalTo(45)
        }
    }
    
    @objc private func handleTap(_ sender: AnyObject?) {
        print("处理点击手势")
        dismiss()
    }
    
    @objc func dismiss() {
        removeFromSuperview()
    }
    
    @objc func nextStep() {
        removeFromSuperview()
    }
    
    func gestureRecognizer(_ gestureRecognizer:UIGestureRecognizer, shouldReceive touch:UITouch) -> Bool {
        if touch.view == self {
            return true
        }
        return false
    }
}

