//
//  YHAdopterIncomeViewModel.swift
//  galaxy
//
//  Created by EDY on 2024/8/23.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHAdopterIncomeViewModel: YHBaseViewModel {

    func postDepositUpload(file: [YHWorkExperienceFileModel], orderId: Int, callBackBlock:@escaping (_ success: Bool,_ error:YHErrorModel?)->()) {
        var urls: [Any] = []
        for item in file {
            let file = ["name": item.fileName, "url": item.fileUrl, "upload_date": item.uploadedAt]
            urls.append(file)
        }
        let params: [String: Any] = ["urls": urls,
                                     "order_id": orderId]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Adopter.depositUpload
        
        let _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            
            if json.code == 200 {
                callBackBlock(true,nil)
            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callBackBlock(false,err)
            }
            
        } failBlock: { err in
            callBackBlock(false,err)
        }
    }
}
