//
//  YHYHAdopterTravelViewModel.swift
//  galaxy
//
//  Created by EDY on 2024/8/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHYHAdopterTravelViewModel: YHBaseViewModel {
    var mainModel: YHAdopterDependentDataDocModel = YHAdopterDependentDataDocModel()
    var name: String = ""
    override init() {
        super.init()
    }
    
    func getBaseDataSource(_ isShowPrompt: Bool) -> [YHItemModel] {
        let item = YHItemModel(id: .id1, isNeed: true, title: "旅行证件类型", isUserKeyBoard: false, prompts: "请选择", message: "\(mainModel.certificates_info.travel_papers_type)", type: .travel, isShowPrompts: isShowPrompt, alertMessage:"请选择旅行证件类型")
        let item1 = YHItemModel(id: .id2, isNeed: true, title: "英文姓名", isUserKeyBoard: true, prompts: "请输入", message: mainModel.certificates_info.en_name, isShowPrompts: isShowPrompt, alertMessage:"请输入英文姓名")
        let item2 = YHItemModel(id: .id3, isNeed: true, title: "旅行证件号码", isUserKeyBoard: true, prompts: "请输入", message: mainModel.certificates_info.travel_papers_number, isShowPrompts: isShowPrompt, alertMessage:"请输入旅行证件号码")
        let item3 = YHItemModel(id: .id4, isNeed: true, title: "签发地点", isUserKeyBoard: true, prompts: "请输入", message: mainModel.certificates_info.sign_address, isShowPrompts: isShowPrompt, alertMessage:"请输入签发地点")
        let item4 = YHItemModel(id: .id5, isNeed: true, title: "签发日期", isUserKeyBoard: false, prompts: "请选择", message: mainModel.certificates_info.sign_date, type: .time, isShowPrompts: isShowPrompt, alertMessage:"请选择签发日期")
        let item5 = YHItemModel(id: .id6, isNeed: true, title: "届满日期", isUserKeyBoard: false, prompts: "请选择", message: mainModel.certificates_info.sign_expire_date, type: .time, isShowPrompts: isShowPrompt, alertMessage:"请选择届满日期")
        return [item, item1, item2, item3, item4, item5]
    }
    
    func getChinaDataSource(_ isShowPrompt: Bool) -> [YHItemModel] {
        let item = YHItemModel(id: .id21, isNeed: true, title: "姓名", isUserKeyBoard: true, prompts: "请输入", message: name, isShowPrompts: isShowPrompt, alertMessage:"请输入姓名")
        let item1 = YHItemModel(id: .id22, isNeed: true, title: "身份证号码", isUserKeyBoard: true, prompts: "请输入", message: mainModel.certificates_info.idcard, isShowPrompts: isShowPrompt, alertMessage:"请输入身份证号码")
        let item2 = YHItemModel(id: .id23, isNeed: true, title: "出生日期", isUserKeyBoard: false, prompts: "请选择", message: mainModel.certificates_info.birthday, type: .time, isShowPrompts: isShowPrompt, alertMessage:"请选择出生日期")
        let item3 = YHItemModel(id: .id24, isNeed: true, title: "出生地点", isUserKeyBoard: true, prompts: "请输入", message: mainModel.certificates_info.birth_place, isShowPrompts: isShowPrompt, alertMessage:"请输入出生地点")
        let item4 = YHItemModel(id: .id25, isNeed: true, title: "性别", isUserKeyBoard: false, prompts: "请选择", message: "\(mainModel.certificates_info.gender)", type: .sex, isShowPrompts: isShowPrompt, alertMessage:"请选择性别")
        return [item, item1, item2, item3, item4]
    }
    
    func updateModel(_ item: YHItemModel) {
        guard let type = item.id else { return }
        switch type {
        case .id1:
            mainModel.certificates_info.travel_papers_type = item.value?.first?.int ?? 0
        case .id2:
            mainModel.certificates_info.en_name = item.message ?? ""
        case .id3:
            mainModel.certificates_info.travel_papers_number = item.message ?? ""
        case .id4:
            mainModel.certificates_info.sign_address = item.message ?? ""
        case .id5:
            mainModel.certificates_info.sign_date = item.message ?? ""
        case .id6:
            mainModel.certificates_info.sign_expire_date = item.message ?? ""
        case .id21:
            name = item.message ?? ""
        case .id22:
            mainModel.certificates_info.idcard = item.message ?? ""
        case .id23:
            mainModel.certificates_info.birthday = item.message ?? ""
        case .id24:
            mainModel.certificates_info.birth_place = item.message ?? ""
        case .id25:
            mainModel.certificates_info.gender = item.value?.first?.int ?? 0
        default:
            break
        }
    }
    
    func updateModel(_ model: YHHKIDCardModel) {
        if model.name.count != 0 {
            mainModel.certificates_info.en_name = model.pingyin
            mainModel.certificates_info.travel_papers_type = 1
        }
        if model.birth.count != 0 {
            mainModel.certificates_info.birthday = model.birth
        }
        if model.gender.count != 0 {
            if model.gender == "女" {
                mainModel.certificates_info.gender = 1
            } else {
                mainModel.certificates_info.gender = 0
            }
        }
        if model.term_begins.count != 0 {
            mainModel.certificates_info.sign_date = model.term_begins
        }
        if model.end_of_term.count != 0 {
            mainModel.certificates_info.sign_expire_date = model.end_of_term
        }
        if model.IssueAddress.count != 0 {
            mainModel.certificates_info.sign_address = model.IssueAddress
        }
        if model.card_num.count != 0 {
            mainModel.certificates_info.travel_papers_number = model.card_num
        }
    }
    
    func updateModel(_ model: YHCNIDCardModel) {
        if model.name.count != 0 {
            mainModel.certificates_info.en_name = model.name
        }
        if model.birth.count != 0 {
            mainModel.certificates_info.birthday = model.birth
        }
        if model.gender.count != 0 {
            if model.gender == "女" {
                mainModel.certificates_info.gender = 2
            } else {
                mainModel.certificates_info.gender = 1
            }
        }
//        if model.term_begins.count != 0 {
//            mainModel.certificates.cn_identity_card.issue_date_start_at = model.term_begins
//        }
//        if model.end_of_term.count != 0 {
//            mainModel.certificates.cn_identity_card.issue_date_end_at = model.end_of_term
//        }
        if model.address.count != 0 {
            mainModel.certificates_info.birth_place = model.address
        }
        if model.card_num.count != 0 {
            mainModel.certificates_info.idcard = model.card_num
        }
    }
    
    func isCanNext(_ step: Int) -> Bool {
        if step == 1 {
            let travel_papers_type = mainModel.certificates_info.travel_papers_type
            let en_name = mainModel.certificates_info.en_name
            let travel_papers_number = mainModel.certificates_info.travel_papers_number
            let sign_address = mainModel.certificates_info.sign_address
            let sign_date = mainModel.certificates_info.sign_date
            let sign_expire_date = mainModel.certificates_info.sign_expire_date
            guard travel_papers_type > 0 else { return false }
            guard en_name.count > 0 else { return false }
            guard travel_papers_number.count > 0 else { return false }
            guard sign_address.count > 0 else { return false }
            guard sign_date.count > 0 else { return false }
            guard sign_expire_date.count > 0 else { return false }
            return true
        } else {
            let idcard = mainModel.certificates_info.idcard
            let birthday = mainModel.certificates_info.birthday
            let birth_place = mainModel.certificates_info.birth_place
            let gender = mainModel.certificates_info.gender
            guard gender < 3 else { return false }
            guard name.count > 0 else { return false }
            guard birthday.count > 0 else { return false }
            guard birth_place.count > 0 else { return false }
            guard idcard.count > 0 else { return false }
            return true
        }
    }
    
    func requestHkIDCardMessage(_ url: String, isBack: Int, callBackBlock:@escaping (_ success: Bool, _ error:YHErrorModel?)->()) {
        let strUrl = YHBaseUrlManager.shared.curOssURL() + YHAllApiName.OCR.hk
        let params: [String : Any] = ["url": url,
                                      "is_back": isBack]
        let _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                guard let dic = json.data?.peel as?  [String : Any],let result = YHHKIDCardModel.deserialize(from: dic) else {
                    callBackBlock(false, nil)
                    return
                }
                self.updateModel(result)
                callBackBlock(true, nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false,err)
        }
    }
    
    func requestCnIDCardMessage(_ url: String, isBack: Int, callBackBlock:@escaping (_ success: Bool, _ error:YHErrorModel?)->()) {
        let strUrl = YHBaseUrlManager.shared.curOssURL() + YHAllApiName.OCR.cn
        let params: [String : Any] = ["url": url,
                                      "is_back": isBack]
        let _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String : Any], let result = YHCNIDCardModel.deserialize(from: dic) else {
                    callBackBlock(false, nil)
                    return
                }
                self.updateModel(result)
                callBackBlock(true, nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false,err)
        }
    }
    
    func postdependentsUpload(urls: [String], callBackBlock:@escaping (_ success: Bool,_ error:YHErrorModel?)->()) {
        var certificates_info: [String: Any] = [:]
        if mainModel.certificates_info.gender == 1 || mainModel.certificates_info.gender == 2 {
            certificates_info.updateValue(mainModel.certificates_info.gender, forKey: "gender")
        }
        if mainModel.certificates_info.marital_status != 0 {
            certificates_info.updateValue(mainModel.certificates_info.marital_status, forKey: "marital_status")
        }
        if mainModel.certificates_info.travel_papers_type != 0 {
            certificates_info.updateValue(mainModel.certificates_info.travel_papers_type, forKey: "travel_papers_type")
        }
        if mainModel.certificates_info.current_place != 0 {
            certificates_info.updateValue(mainModel.certificates_info.current_place, forKey: "current_place")
        }
        if mainModel.certificates_info.is_forever_identiry != 0 {
            certificates_info.updateValue(mainModel.certificates_info.is_forever_identiry, forKey: "is_forever_identiry")
        }
        if mainModel.certificates_info.is_live_hk != 0 {
            certificates_info.updateValue(mainModel.certificates_info.is_live_hk, forKey: "is_live_hk")
        }
        if mainModel.certificates_info.hk_identity != 0 {
            certificates_info.updateValue(mainModel.certificates_info.hk_identity, forKey: "hk_identity")
        }
        if mainModel.certificates_info.en_name.count != 0 {
            certificates_info.updateValue(mainModel.certificates_info.en_name, forKey: "en_name")
        }
        if mainModel.certificates_info.former_name.count != 0 {
            certificates_info.updateValue(mainModel.certificates_info.former_name, forKey: "former_name")
        }
        if mainModel.certificates_info.birthday.count != 0 {
            certificates_info.updateValue(mainModel.certificates_info.birthday, forKey: "birthday")
        }
        if mainModel.certificates_info.birth_place.count != 0 {
            certificates_info.updateValue(mainModel.certificates_info.birth_place, forKey: "birth_place")
        }
        if mainModel.certificates_info.idcard.count != 0 {
            certificates_info.updateValue(mainModel.certificates_info.idcard, forKey: "idcard")
        }
        if mainModel.certificates_info.hk_idcard.count != 0 {
            certificates_info.updateValue(mainModel.certificates_info.hk_idcard, forKey: "hk_idcard")
        }
        if mainModel.certificates_info.travel_papers_number.count != 0 {
            certificates_info.updateValue(mainModel.certificates_info.travel_papers_number, forKey: "travel_papers_number")
        }
        if mainModel.certificates_info.sign_address.count != 0 {
            certificates_info.updateValue(mainModel.certificates_info.sign_address, forKey: "sign_address")
        }
        if mainModel.certificates_info.sign_date.count != 0 {
            certificates_info.updateValue(mainModel.certificates_info.sign_date, forKey: "sign_date")
        }
        if mainModel.certificates_info.sign_expire_date.count != 0 {
            certificates_info.updateValue(mainModel.certificates_info.sign_expire_date, forKey: "sign_expire_date")
        }
        if mainModel.certificates_info.live_time.count != 0 {
            certificates_info.updateValue(mainModel.certificates_info.live_time, forKey: "live_time")
        }
        if mainModel.certificates_info.approve_date.count != 0 {
            certificates_info.updateValue(mainModel.certificates_info.approve_date, forKey: "approve_date")
        }
        if mainModel.certificates_info.will_to_hk_date.count != 0 {
            certificates_info.updateValue(mainModel.certificates_info.will_to_hk_date, forKey: "will_to_hk_date")
        }
        if mainModel.certificates_info.will_live_time.count != 0 {
            certificates_info.updateValue(mainModel.certificates_info.will_live_time, forKey: "will_live_time")
        }
        var params: [String: Any] = ["id": mainModel.id,
                                    "url": urls]
        if !certificates_info.isEmpty {
            params.updateValue(certificates_info, forKey: "certificates_info")
        }
//        let params: [String: Any] = ["id": id,
//                                     "is_read_agreement": 1,
//                                     "order_id": mainModel.info.order_id]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Adopter.dependentsUpload
        
        let _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            
            if json.code == 200 {
                callBackBlock(true,nil)
            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callBackBlock(false,err)
            }
            
        } failBlock: { err in
            callBackBlock(false,err)
        }
    }
}
