//
//  YHUploadCertificateVC.swift
//  galaxy
//
//  Created by davidhuangA on 2024/8/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHUploadCertificateVC: YHBaseViewController {
    
    lazy var viewModel: YHUploadCertificateViewModel = {
        let vm = YHUploadCertificateViewModel()
        return vm
    }()
    
    var orderId : Int = 0

    lazy var tableView: UITableView = {
        let tableView = UITableView(frame:.zero, style:.grouped)
        tableView.estimatedSectionHeaderHeight = 16.0
        tableView.estimatedSectionFooterHeight = 0.01
        tableView.contentInsetAdjustmentBehavior = .never
        tableView.showsVerticalScrollIndicator = false
        tableView.separatorStyle = .none
        tableView.delegate = self
        tableView.dataSource = self
        tableView.backgroundColor = .clear
        tableView.register(UITableViewCell.self, forCellReuseIdentifier: "UITableViewCell")
        tableView.register(YHUploadCertificateTitleCell.self, forCellReuseIdentifier: YHUploadCertificateTitleCell.cellReuseIdentifier)
        tableView.register(YHUploadCertificateDetailCell.self, forCellReuseIdentifier: YHUploadCertificateDetailCell.cellReuseIdentifier)
        return tableView
    }()
    
    
    //我已知悉，确认
    lazy var rewardBtn: UIButton = {
        let button = UIButton(type: .custom)
        button.titleLabel?.font = UIFont.PFSC_M(ofSize: 15)
        button.contentHorizontalAlignment = .center
        button.setTitle("我已全部缴费，下一步", for: .normal)
        button.setTitle("缴费结果更新中，请耐心等待", for: .disabled)
        button.setTitleColor(UIColor.white, for: .normal)
        button.setTitleColor(UIColor.white, for: .disabled)
        button.layer.cornerRadius = kCornerRadius3
        button.clipsToBounds = true
        button.addTarget(self, action: #selector(clickNextBtn), for: .touchUpInside)
        button.backgroundColor = UIColor.brandMainColor
        return button
    }()
    
    lazy var bottomView: UIView = {
        let view = UIView()
        view.backgroundColor = .clear
        view.addSubview(self.rewardBtn)
        self.rewardBtn.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(10)
            make.left.equalTo(kMargin)
            make.right.equalTo(-kMargin)
            make.height.equalTo(44)
        }
        view.layer.zPosition = 10
        return view
    }()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setupUI()
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        loadData()
    }
}

private extension YHUploadCertificateVC {
    
    func  loadData() {
        viewModel.getUploadCertificateList(orderId) { success, error in
            if success {
                
            } else {
                
            }
            self.tableView.reloadData()
        }
    }
    
    func setupUI() {
        gk_navTitle = "上传过关证件"
        gk_navBarAlpha = 1.0
        gk_navBackgroundColor = .white
        view.backgroundColor = UIColor.contentBkgColor
        
        view.addSubview(tableView)
        
        tableView.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(kMargin)
            make.right.equalToSuperview().offset(-kMargin)
            make.top.equalTo(k_Height_NavigationtBarAndStatuBar)
            make.bottom.equalToSuperview()
        }
    }
    
    
    @objc func clickNextBtn() {
        YHHUD.flash(message: "预计会在1个工作日内更新缴费结果")
        disableSureButton()
    }
    
    func disableSureButton() {
        rewardBtn.isEnabled = false
        rewardBtn.backgroundColor = UIColor.brandMainColor30
    }
}


extension YHUploadCertificateVC: UITableViewDelegate, UITableViewDataSource {
    
    func numberOfSections(in tableView: UITableView) -> Int {
        
        if let model = viewModel.uploadCertificateDataListModel {
            var session = 0
            if !model.small_whites.isEmpty {
                session += 1
            }
            
            if !model.id_cards.isEmpty {
                session += 1
            }
            return session
        }
        
        return 0
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        if let model = viewModel.uploadCertificateDataListModel {
            if section == 0  {
                return model.small_whites.count + 1
            } else if section == 1 {
                return model.id_cards.count + 1
            }
        }
        return 0
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        if indexPath.row == 0 {
            let warningCell = tableView.dequeueReusableCell(withIdentifier: YHUploadCertificateTitleCell.cellReuseIdentifier, for: indexPath) as! YHUploadCertificateTitleCell
            
            var title = ""
            if indexPath.section == 0 {
                title = "小白条"
            } else {
                title = "香港身份证"
            }
            warningCell.updateTitle(title)
            return warningCell
        } else {
            let approveCell = tableView.dequeueReusableCell(withIdentifier: YHUploadCertificateDetailCell.cellReuseIdentifier, for: indexPath) as! YHUploadCertificateDetailCell
            
            if let model = viewModel.uploadCertificateDataListModel {
                if indexPath.section == 0  {
                    let tmp = model.small_whites[indexPath.row - 1]
                    approveCell.dataModel = tmp
                    
                    if indexPath.row == model.small_whites.count {
                        approveCell.isLastCell = true
                    } else {
                        approveCell.isLastCell = false
                    }
                } else if indexPath.section == 1 {
                    let tmp = model.id_cards[indexPath.row - 1]
                    approveCell.dataModel = tmp
                    
                    if indexPath.row == model.id_cards.count {
                        approveCell.isLastCell = true
                    } else {
                        approveCell.isLastCell = false
                    }
                }
            }
            return approveCell
        }
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        if indexPath.row == 0 {
            return YHUploadCertificateTitleCell.cellH
        }
        return YHUploadCertificateDetailCell.cellH
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        let vc = YHUploadCertificateDetailVC()
        if let model = viewModel.uploadCertificateDataListModel {
            var tmp : YHUploadCertificateModel?
            if indexPath.section == 0  {
                if model.small_whites.count > 0,indexPath.row - 1 < model.small_whites.count {
                    tmp = model.small_whites[indexPath.row - 1]
                    vc.detailType = .SmallWhiteNote
                }
            } else if indexPath.section == 1 {
                if model.id_cards.count > 0,indexPath.row - 1 < model.id_cards.count {
                    tmp = model.id_cards[indexPath.row - 1]
                    vc.detailType = .HongKongCard
                }
            }
            
            if let tmp = tmp {
                vc.dataModel = tmp
                self.navigationController?.pushViewController(vc)
            }
        }
    }
    
    private func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> CGFloat {
        return 16.0
    }
    
    private func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> CGFloat {
        return 0.01
    }
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        
        let view = UIView()
        return view
    }
    
    func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> UIView? {
        
        let view = UIView()
        return view
    }
}
