//
//  YHPayMemberContentItem.swift
//  galaxy
//
//  Created by davidhuangA on 2024/8/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHPayMemberContentItem: UIView {
    
    
    private var urlPdf : String?
    
    
    
    lazy var previewFileTool:YHFilePreviewTool = {
        let tool = YHFilePreviewTool(targetVC: UIViewController.current)
       return tool
    }()
    
    
    lazy var viewModel: YHBaseViewModel = {
        let vm = YHBaseViewModel()
        return vm
    }()
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.font = UIFont.PFSC_R(ofSize: 13)
        label.text = "档案号："
        label.textColor = UIColor.mainTextColor70
        return label
    }()
    
    lazy var detailLabel: UILabel = {
        let label = UILabel()
        label.numberOfLines = 0
        label.font = UIFont.PFSC_R(ofSize: 13)
        label.text = ""
        label.textColor = UIColor.mainTextColor
        label.textAlignment = .right
        label.lineBreakMode = .byTruncatingMiddle
        return label
    }()
    
    
    lazy var copyBtn: UIButton = {
        let btn = UIButton()
        btn.setTitle("复制", for: .normal)
        btn.setTitleColor(UIColor.mainTextColor, for: .normal)
        btn.titleLabel?.font = UIFont.PFSC_M(ofSize: 10)
        btn.backgroundColor = UIColor.separatorColor
        btn.layer.cornerRadius = 9.0 //36 18
        btn.clipsToBounds = true
        btn.addTarget(self, action: #selector(clickCopyBtn), for: .touchUpInside)
        btn.layer.zPosition = 10
        return btn
    }()
    
    
    //用来自动布局
    lazy var fakeView: UIView = {
        let view = UIView()
        return view
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
}

private extension YHPayMemberContentItem {
    @objc func clickCopyBtn() {
        if let title = copyBtn.titleForNormal {
            
            if title.contains("复制") {
                UIPasteboard.general.string = self.detailLabel.text
                YHHUD.flash(message: "已复制档案号")
            } else {
                //查看
                if let url = urlPdf,!url.isEmpty {
                    
                    YHHUD.show(.progress(message: "加载中..."))
                    self.viewModel.getRealUsefulUrl(url) {
                        [weak self] resultUrl in
                        YHHUD.hide()
                        guard let self = self else { return }
                        self.previewFileTool.openXLSXRemoteFile(urlString: resultUrl, fileName:"")
                    }
                    
                }
            }
        }
    }
    
    func setupUI() {
        backgroundColor = .clear
    }
}


extension YHPayMemberContentItem {
    func updateUI(title : String = "",detail : String = "",oneLine : Bool = true, showBtn : Bool = false) {
        
        
        urlPdf = detail
        
        titleLabel.removeFromSuperview()
        detailLabel.removeFromSuperview()
        copyBtn.removeFromSuperview()
        
        addSubview(titleLabel)
        addSubview(detailLabel)
        addSubview(fakeView)
        titleLabel.text = title
        let arr = detail.split(separator: "/")
        if arr.count > 0 {
            if let txt = arr.last {
                detailLabel.text = String(txt)
            }
        }
        
        
        if oneLine {
            copyBtn.setTitle("复制", for: .normal)
            detailLabel.textAlignment = .right
            titleLabel.snp.makeConstraints { make in
                make.centerY.equalToSuperview()
                make.height.equalTo(18)
                make.left.equalToSuperview()
            }
            
            if showBtn {
                addSubview(copyBtn)
                copyBtn.snp.makeConstraints { make in
                    make.centerY.equalToSuperview()
                    make.height.equalTo(18)
                    make.width.equalTo(36)
                    make.right.equalToSuperview()
                }
                
                
                detailLabel.snp.makeConstraints { make in
                    make.centerY.equalToSuperview()
                    make.height.equalTo(18)
                    make.left.equalTo(titleLabel.snp.right).offset(kMargin)
                    make.right.equalToSuperview().offset(-42)
                }
                
            } else {
                detailLabel.snp.makeConstraints { make in
                    make.centerY.equalToSuperview()
                    make.height.equalTo(18)
                    make.left.equalTo(titleLabel.snp.right).offset(kMargin)
                    make.right.equalToSuperview()
                }
            }
        } else {
            detailLabel.textAlignment = .left
            copyBtn.setTitle("查看", for: .normal)
            titleLabel.snp.makeConstraints { make in
                make.top.equalToSuperview()
                make.height.equalTo(18)
                make.left.equalToSuperview()
                make.right.equalToSuperview()
            }
            
            if showBtn {
                detailLabel.snp.makeConstraints { make in
                    make.top.equalTo(titleLabel.snp.bottom).offset(8)
                    make.height.equalTo(20)
                    make.left.equalToSuperview()
                    make.right.equalToSuperview().offset(-42)
                }
                
                addSubview(copyBtn)
                copyBtn.snp.makeConstraints { make in
                    make.centerY.equalTo(detailLabel.snp.centerY)
                    make.height.equalTo(18)
                    make.width.equalTo(36)
                    make.right.equalToSuperview()
                }
                
            } else {
                detailLabel.snp.makeConstraints { make in
                    make.top.equalTo(titleLabel.snp.bottom).offset(8)
                    make.height.equalTo(20)
                    make.left.equalToSuperview()
                    make.right.equalToSuperview()
                }
            }

        }
        
        fakeView.snp.makeConstraints { make in
            make.top.equalTo(detailLabel.snp.bottom)
            make.left.right.equalToSuperview()
            make.height.equalTo(1)
            
            make.bottom.equalToSuperview()
        }
        
        
        copyBtn.YH_clickEdgeInsets = UIEdgeInsets(top: 10, left: 10, bottom: 10, right: 10)
    }
}
