//
//  YHPayMemberSectionItem.swift
//  galaxy
//
//  Created by davidhuangA on 2024/8/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHPayMemberSectionItem: UIView {
    static let viewH : CGFloat = 22.0
    
    var  dataModel : YHVisaPaymentModel? {
        didSet {
            updateUI()
        }
    }
    
    lazy var tagView: UIView = {
        let view = UIView()
        view.backgroundColor = .brandMainColor
        return view
    }()
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.font = UIFont.PFSC_M(ofSize: 16)
        label.text = "张全蛋"
        return label
    }()
    
    lazy var detailLabel: UILabel = {
        let label = UILabel()
        label.numberOfLines = 0
        label.font = UIFont.PFSC_M(ofSize: 13)
        label.text = "已缴费"
        label.textColor = UIColor.mainTextColor50
        label.textAlignment = .right
        return label
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
}

private extension YHPayMemberSectionItem {
    func setupUI() {
        addSubview(tagView)
        addSubview(titleLabel)
        addSubview(detailLabel)
        
        tagView.snp.makeConstraints { make in
            make.left.equalToSuperview()
            make.centerY.equalToSuperview()
            make.height.equalTo(14)
            make.width.equalTo(3)
        }
        
        
        detailLabel.snp.makeConstraints { make in
            make.right.equalToSuperview()
            make.centerY.equalToSuperview()
            make.height.equalTo(20)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(tagView.snp.right).offset(6)
            make.centerY.equalToSuperview()
            make.right.equalTo(detailLabel.snp.left).offset(-kMargin)
            make.height.equalTo(20)
        }
    }
}


extension YHPayMemberSectionItem {
    func updateUI() {
        
        guard let model = dataModel else { return }
        
        var txt = "待缴费"
        var color : UIColor = UIColor.failColor
        //支付状态 7-待缴费 8-已缴费 9-电子签证已过期
        if model.pay_status == 7 {
            txt = "待缴费"
            color = .brandMainColor
        } else if model.pay_status == 9 {
            txt = "已过期"
            color = .failColor
            
        } else if model.pay_status == 8 {
            txt = "已缴费"
            color = .mainTextColor50
        }
        titleLabel.text = model.name
        
        detailLabel.text = txt
        detailLabel.textColor = color
        
    }
}
