//
//  YHOfficailLetterColledtionCell.swift
//  galaxy
//
//  Created by davidhuangA on 2024/8/11.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import FSPagerView

class YHOfficailLetterColledtionCell: FSPagerViewCell {
    static let cellReuseIdentifier = "YHOfficailLetterColledtionCell"
    
    
    var dataModel: YHOfficalLetterModel? {
        didSet {
            updateUI()
        }
    }
    
    lazy var bkgImageView:UIImageView = {
        let imageV = UIImageView(image: UIImage(named: "official_approval_result_envelope_not_read"))
        imageV.contentMode = .scaleAspectFill
        return imageV
    }()
    
    
    lazy var nameLable:UILabel = {
        let label = UILabel()
        label.text = ""
        label.textColor = UIColor(hex: 0xA96B42, alpha: 1.0)
        label.font = UIFont.PFSC_M(ofSize: 15)
        return label
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        contentView.removeSubviews()
        setupUI()
    }
    
    
    
    
    
}

private extension YHOfficailLetterColledtionCell {
    func setupUI() {
        backgroundColor = .clear
        contentView.backgroundColor = .clear
        clipsToBounds = true
        
        contentView.layer.shadowColor = UIColor.clear.cgColor
        contentView.layer.shadowRadius = 0
        contentView.layer.shadowOpacity = 0
        contentView.layer.shadowOffset = .zero
        
        
        contentView.addSubview(bkgImageView)
        bkgImageView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        contentView.addSubview(nameLable)
        nameLable.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(kMargin + 12)
            make.left.equalToSuperview().offset(60)
            make.height.equalTo(21)
        }
    }
    
    func updateUI() {
        guard let model = dataModel else { return }
        nameLable.text = model.applicant
        
        if model.read_status == 0 {
            //未读
            bkgImageView.image = UIImage(named: "official_approval_result_envelope_not_read")
        } else {
            //已读
            bkgImageView.image = UIImage(named: "official_approval_result_envelope_readed")
        }
    }
}
