//
//  YHPrincipleApprovedResultVC.swift
//  galaxy
//
//  Created by edy on 2024/8/12.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHPrincipleApprovedResultVC: YHBaseViewController {

    var orderId: Int = -1
    let viewModel = YHPrincleViewModel()
    
    // 已获批且已发送邮件页面
    lazy var mailVC: YHPrincipleApprovedMailViewController = {
        let vc = YHPrincipleApprovedMailViewController()
        vc.orderId = self.orderId
        vc.view.isHidden = true
        return vc
    }()
    
    lazy var preSubmitVC: YHPrincipleApprovedWaitSubmitVC = {
        let vc = YHPrincipleApprovedWaitSubmitVC()
        vc.orderId = self.orderId
        vc.view.isHidden = true
        return vc
    }()
    
    lazy var uploadListVC: YHPrincipleUploadListVC = {
        let vc = YHPrincipleUploadListVC()
        vc.orderId = self.orderId
        vc.view.isHidden = true
        return vc
    }()

    override func viewDidLoad() {
        super.viewDidLoad()
        self.view.backgroundColor = .white
        
        self.addChild(mailVC)
        self.addChild(preSubmitVC)
        self.addChild(uploadListVC)
        
        self.view.addSubview(mailVC.view)
        self.view.addSubview(preSubmitVC.view)
        self.view.addSubview(uploadListVC.view)

        YHHUD.show(.progress(message:"加载中"))
        self.viewModel.requestIsSendMail(orderId: self.orderId) { isSend in
            YHHUD.hide()
            if isSend {
                // 已发送邮件
                self.mailVC.requestData()
                self.mailVC.view.isHidden = false
                return
            }
            // 未发送邮件
            YHHUD.show(.progress(message:"加载中"))
            self.viewModel.getEnvelopeInfo(orderId: self.orderId) { success, error in
                YHHUD.hide()
                // 已获得港府甄选名额
                if !self.viewModel.envelopModel.name.isEmpty, !self.viewModel.envelopModel.url.isEmpty {
                    // 进入原则批已获批待提交页面
                    self.preSubmitVC.requestData()
                    self.preSubmitVC.view.isHidden = false
                    
                } else {
                    // 进入原则批上传列表页面
                    self.uploadListVC.requestData()
                    self.uploadListVC.view.isHidden = false
                }
            }
        }

    }
}
