//
//  YHPrincipleUploadModel.swift
//  galaxy
//
//  Created by edy on 2024/8/8.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SmartCodable
import AttributedString

class YHPrincipleUploadDetailModel: SmartCodable {
    
    var date: String = ""
    var applicant: YHPrincipleApplicantModel = YHPrincipleApplicantModel()
    var file_data: YHPrincipleFileDataModel = YHPrincipleFileDataModel()
    
    func convertDateFormat() -> String {
        let dateFormatter = DateFormatter()
        dateFormatter.dateFormat = "yyyy-MM-dd"
        
        if let date = dateFormatter.date(from: date) {
            dateFormatter.dateFormat = "yyyy年MM月dd日"
            return dateFormatter.string(from: date)
        }
        return date
    }
    
    required init() {
        
    }
}

class YHPrincipleApplicantModel: SmartCodable {
    var id: Int = 0
    var sex: Int = 0
    var username: String = ""
    
    required init() {
        
    }
}

class YHPrincipleFileDataModel: SmartCodable  {
    var agreement: YHPrincipleAgreementModel = YHPrincipleAgreementModel()
    var opinion: YHPrincipleAgreementModel = YHPrincipleAgreementModel()
    var other: YHPrincipleAgreementModel = YHPrincipleAgreementModel()
    
    required init() {
        
    }
}

class YHPrincipleFileUrlModel: SmartCodable  {
    var name: String = ""
    var url: String = ""
    
    required init() {
        
    }
}

class YHPrincipleNameExtraModel: SmartCodable  {
    var organization: String = ""
    var applicant: String = ""
    
    required init() {
        
    }
}

class YHPrincipleContentUrlModel: SmartCodable  {
    var name: String = ""
    var url: String = ""
    var type: Int = 1
    var fileUrl: String = ""
    var updated_at: String = ""
    
    // 获取文件后缀名 eg:123.pdf -> pdf
    func getFileSuffixName()->String {
        let res1 = name.pathExtension.lowercased()
        if !res1.isEmpty {
            return res1
        }
        let res2 = url.pathExtension.lowercased()
        if !res2.isEmpty {
            return res2
        }
        return ""
    }
    
    // 获取文件名(不包含后缀) eg:123.pdf -> 123
    func getFileNameWithoutSuffix()->String {
        if name.isEmpty {
            return name
        }
        if !name.contains(".") {
            return name
        }
        if !name.pathExtension.isEmpty {
          let fileName = (name as NSString).deletingPathExtension
          return fileName
        }
        return ""
    }
    
    required init() {
        
    }
}

enum YHPrincipleAgreementType: Int {
    case none = 0
    case agreement = 1 // 同意书
    case opinion = 2   // 申请人意见访问
    case other = 3     // 其他证明条件
}

class YHPrincipleAgreementModel: SmartCodable  {
    
    var id: Int = 0
    var order_id: Int = 0
    var plan_id: Int = 0
    var file_id: Int = 0
    var file_url = [YHPrincipleFileUrlModel]()
    var document_url: String = ""
    var type: Int = 0
    var order_subset_id: Int = 0
    var template_name: String = ""
    var template_provider: String = ""
    var template_row_sort: Int = 0
    var template_row: Int = 0
    var template_cate_name: String = ""
    var template_cate_id: Int = 0
    var template_id: Int = 0
    var template_type: Int = 0
    var name: String = ""
    var name_extra: YHPrincipleNameExtraModel = YHPrincipleNameExtraModel()
    var name_temp: String = ""
    var applicant_name: String = ""
    var is_original: Int = 0
    var is_check: Int = 0
    var upload_requirement: Int = 0
    var submit_time: String = ""
    var check_status: Int = YHPrincipleUploadStatus.preUpload.rawValue
    var audit_content: String = ""
    var audit_content_crm: String = ""
    var sort: Int = 0
    var finalized_file = [YHPrincipleFileUrlModel]()
    var progress_type: Int = 0
    var document_check_status: Int = 0
    var document_check_time: String = ""
    var document_submit_time: String = ""
    var document_audit_content: String = ""
    var check_time: String = ""
    var assign_at: String = ""
    var collect_status: Int = 0
    var content_url = [YHPrincipleContentUrlModel]()
    var original_content_url = [YHPrincipleContentUrlModel]()
    var ship_company: String = ""
    var ship_code: String = ""
    var remark: String = ""
    var ship_remark: String = ""
    var node: Int = 0
    var state: Int = 0
    var renew_state: Int = 0
    var original: Int = 0
    var old_id: Int = 0
    var approved_add: Int = 0
    var delay_supplement_log: String = ""
    var content_upload_by: String = ""
    var mark_completed: Int = 0
    var chart_type: Int = 0
    var chart_data: String = ""
    var chart_push_type: Int = 0
    var client_display: Int = 0
    var deleted_at: String = ""
    var created_at: String = ""
    var updated_at: String = ""
    var send_client_time: String = ""
    var system_check_status: Int = 0
    var system_check_time: String = ""
    var create_from_appid: Int = 0
    var update_from_appid: Int = 0
    var first_submit_time: String = ""
    var is_system_check_async: Int = 0
    var generated_state: Int = 0
    var document_type: Int = 0
    var process_status: Int = 0
    var dwp_status: Int = 0
    var ocr: String = ""
    var handle_remark: String = ""
    var rejection_confirmation: Int = 0
    
    // 自定义属性
    var customType: Int = YHPrincipleAgreementType.none.rawValue
    var isMust: Bool {// 是否必须 0：必须提供 1：无需提供
        get {
           return self.upload_requirement == 0
        }
    }
    
    var isNeedTemplate: Bool = false
    var isNeedUploadBtn: Bool {
        // 待上传或已驳回状态才显示上传按钮 且最多上传10个
        get {
            return (self.check_status == YHPrincipleUploadStatus.preUpload.rawValue ||
                    self.check_status == YHPrincipleUploadStatus.rejected.rawValue)
        }
    }
    
    var isCanUpload: Bool {
        get {
            return (self.check_status == YHPrincipleUploadStatus.preUpload.rawValue ||
                    self.check_status == YHPrincipleUploadStatus.rejected.rawValue)
        }
    }
    
    // 是否展示上传状态
    var isNeedUploadStatus: Bool {
        return self.check_status != YHPrincipleUploadStatus.preUpload.rawValue
    }
    
    // 灰色提示语
    var tips: String = ""
    // 黑色或富文本
    var tips1: String = ""
    // 最底部红色提示语
    var isShowRedTips: Bool = false
    // 是否展开
    var isUnfold: Bool = false
    
    required init() {
        
    }
}



