//
//  YHFileListBottomView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/3/18.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHFileListBottomView: UIView {
    static let viewH : CGFloat = 98.0
    
    override init(frame: CGRect) {
        super.init(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: YHBasicInfoFillBottomView.viewH))
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    
    
    typealias Block = (Int) -> ()
    var block: Block?
    var nextButton: UIButton!
}

private extension YHFileListBottomView {
    func setupUI() {
        backgroundColor = .white
        nextButton = {
            let button = UIButton(type: .custom)
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 15)
            button.contentHorizontalAlignment = .center
            button.setTitle("保存清单图", for: .normal)
            button.setTitleColor(.white, for: .normal)
            button.layer.cornerRadius = kCornerRadius3
            button.clipsToBounds = true
            button.addTarget(self, action: #selector(submit), for: .touchUpInside)
            button.backgroundColor = UIColor.brandMainColor
            return button
        }()
        addSubview(nextButton)
        nextButton.snp.makeConstraints { make in
            make.right.equalTo(-kMargin)
            make.top.equalTo(8)
            make.height.equalTo(44)
            make.left.equalTo(kMargin)
        }
        
    }
    
    @objc func submit() {
        block?(1)
    }
}


extension YHFileListBottomView {
    func updateBtnTitle(title : String) {
        nextButton.setTitle(title, for: .normal)
    }
}
