//
//  YHFileListEmptyView.swift
//  galaxy
//
//  Created by edy on 2024/6/5.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHFileListEmptyView: UIView {
    
    var bottomBtnClick:(()->())?
    
    var emptyBgImgV: UIImageView = {
        let imgView = UIImageView(image: UIImage(named: "my_cer_filelist_empty"))
        return imgView
    }()
    
    lazy var tipsLabel: UILabel = {
        let label = UILabel()
        label.textColor = UIColor.mainTextColor
        label.font = .PFSC_M(ofSize: 14)
        label.textAlignment = .center
        label.text = "恭喜您已完成所有证件的上传".local
        return label
    }()
    
    lazy var bottomBtn: UIButton = {
       let btn = UIButton()
        btn.backgroundColor = .brandMainColor
        btn.setTitle("返回服务主页", for: .normal)
        btn.setTitleColor(.white, for: .normal)
        btn.titleLabel?.font = UIFont.PFSC_M(ofSize: 13)
        btn.layer.cornerRadius = kCornerRadius3
        btn.addTarget(self, action: #selector(didBottomBtnClicked), for: .touchUpInside)
        return btn
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    @objc func didBottomBtnClicked() {
        bottomBtnClick?()
    }
    
    func createUI() {
        self.backgroundColor = .white
        
        self.addSubview(emptyBgImgV)
        self.addSubview(tipsLabel)
        self.addSubview(bottomBtn)

        emptyBgImgV.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(148)
            make.width.height.equalTo(128.0)
            make.centerX.equalTo(self)
        }
        
        tipsLabel.snp.makeConstraints { make in
            make.top.equalTo(emptyBgImgV.snp.bottom).offset(12)
            make.height.equalTo(20)
            make.centerX.equalTo(self)
        }
        
        bottomBtn.snp.makeConstraints { make in
            make.width.equalTo(110)
            make.height.equalTo(38)
            make.top.equalTo(tipsLabel.snp.bottom).offset(22)
            make.centerX.equalTo(self)
        }
    }
}
